//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.OperatorPartTraits;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;
using SharpDX.Direct3D;

namespace Framefield.Core.IDd3c24ad2_dafb_439e_931f_a0c9b128f433
{
    public class Class_SplineDistort : FXSourceCodeFunction, IFXSceneSourceCode, IMeshSupplier
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            RGBANoise = 2,
            uShift2 = 3,
            MeshOffsetX = 4,
            MeshOffsetY = 5,
            MeshOffsetZ = 6,
            DirectionX = 7,
            DirectionY = 8,
            DirectionZ = 9,
            DirectionRegionUStep = 10,
            DirectionRegionStepSmooth = 11,
            NoiseAmount = 12,
            NoiseRegionUStep = 13,
            NoiseRegionStepSmooth = 14,
            NoiseTime = 15,
            NoiseScale = 16,
            UpVectorX = 17,
            UpVectorY = 18,
            UpVectorZ = 19
        }
        //<<< _inputids

        public Class_SplineDistort()
        {
            _meshCollector = new MeshCollector(this);
        }

        public override void Dispose() 
        {
            Utilities.DisposeObj(ref _mesh);
            base.Dispose();
        }

        public void AddMeshesTo(ICollection<Mesh> meshes)
        {
            UpdateMesh(new OperatorPartContext(), OperatorPart.Connections);
            if (_mesh != null)
                meshes.Add(_mesh);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            try
            {
                UpdateMesh(context, inputs);

                if (_mesh.Vertices != null)
                {
                    // render stream output to screen or whatever target is set
                    context.Renderer.SetupEffect(context);
                    context.Renderer.Render(_mesh, context);
                }
            }
            catch (Exception exception)
            {
                Logger.Error(this, "Load Effect error: {0}", exception.Message);
            }

            return context;
        }

        bool _firstEval = true;
        private void UpdateMesh(OperatorPartContext context, List<OperatorPart> inputs)
        {
            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            if (!Changed && _mesh.Vertices != null)
                return;

            //>>> __params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var RGBANoise = inputs[(int)InputId.RGBANoise].Eval(context).Image; 
            var uShift = inputs[(int)InputId.uShift2].Eval(context).Value;
            var MeshOffsetX = inputs[(int)InputId.MeshOffsetX].Eval(context).Value;
            var MeshOffsetY = inputs[(int)InputId.MeshOffsetY].Eval(context).Value;
            var MeshOffsetZ = inputs[(int)InputId.MeshOffsetZ].Eval(context).Value;
            var MeshOffset = new Vector3(MeshOffsetX, MeshOffsetY, MeshOffsetZ);
            var DirectionX = inputs[(int)InputId.DirectionX].Eval(context).Value;
            var DirectionY = inputs[(int)InputId.DirectionY].Eval(context).Value;
            var DirectionZ = inputs[(int)InputId.DirectionZ].Eval(context).Value;
            var Direction = new Vector3(DirectionX, DirectionY, DirectionZ);
            var DirectionRegionUStep = inputs[(int)InputId.DirectionRegionUStep].Eval(context).Value;
            var DirectionRegionStepSmooth = inputs[(int)InputId.DirectionRegionStepSmooth].Eval(context).Value;
            var DirectionRegion = new Vector2(DirectionRegionUStep, DirectionRegionStepSmooth);
            var NoiseAmount = inputs[(int)InputId.NoiseAmount].Eval(context).Value;
            var NoiseRegionUStep = inputs[(int)InputId.NoiseRegionUStep].Eval(context).Value;
            var NoiseRegionStepSmooth = inputs[(int)InputId.NoiseRegionStepSmooth].Eval(context).Value;
            var NoiseRegion = new Vector2(NoiseRegionUStep, NoiseRegionStepSmooth);
            var NoiseTime = inputs[(int)InputId.NoiseTime].Eval(context).Value;
            var NoiseScale = inputs[(int)InputId.NoiseScale].Eval(context).Value;
            var UpVectorX = inputs[(int)InputId.UpVectorX].Eval(context).Value;
            var UpVectorY = inputs[(int)InputId.UpVectorY].Eval(context).Value;
            var UpVectorZ = inputs[(int)InputId.UpVectorZ].Eval(context).Value;
            var UpVector = new Vector3(UpVectorX, UpVectorY, UpVectorZ);
            //<<< __params

            if (Scene.Func.Changed || _mesh.Vertices == null)
            {
                //Logger.Info(this, "collect meshes");
                _meshCollector.Collect(Scene);
                Scene.Func.Changed = false;
            }

            var inputMesh = _meshCollector.FirstMeshOrDefault;
            if (inputMesh == null)
                return;

            _mesh.AttributesSize = inputMesh.AttributesSize;
            _mesh.NumTriangles = inputMesh.NumTriangles;
            _mesh.InputElements = inputMesh.InputElements;
            if (_mesh.Vertices == null || _mesh.Vertices.Description.SizeInBytes != inputMesh.Vertices.Description.SizeInBytes)
            {
                if (_mesh.Vertices != null)
                    _mesh.Vertices.Dispose();

                _mesh.Vertices = new Buffer(D3DDevice.Device, new BufferDescription()
                                                                    {
                                                                        BindFlags = BindFlags.StreamOutput | BindFlags.VertexBuffer,
                                                                        CpuAccessFlags = CpuAccessFlags.None,
                                                                        OptionFlags = ResourceOptionFlags.None,
                                                                        SizeInBytes = _mesh.NumTriangles*inputMesh.AttributesSize*3,
                                                                        Usage = ResourceUsage.Default
                                                                    });
            }
            var noiseTextureView = new ShaderResourceView(context.D3DDevice, RGBANoise);
            _effect.GetVariableByName("RGBANoise").AsShaderResource().SetResource(noiseTextureView);
            
            _effect.GetVariableByName("uShift").AsScalar().Set(uShift);
            _effect.GetVariableByName("MeshOffset").AsVector().Set(MeshOffset);
            _effect.GetVariableByName("Direction").AsVector().Set(Direction);
            _effect.GetVariableByName("DirectionRegion").AsVector().Set(DirectionRegion);
             
            _effect.GetVariableByName("NoiseAmount").AsScalar().Set(NoiseAmount);            
            _effect.GetVariableByName("NoiseRegion").AsVector().Set(NoiseRegion);
            _effect.GetVariableByName("NoiseTime").AsScalar().Set(NoiseTime);
            _effect.GetVariableByName("NoiseScale").AsScalar().Set(NoiseScale);
            
            _effect.GetVariableByName("UpVector").AsVector().Set(UpVector);
                        

            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(_mesh.Vertices, 0) });
            context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState = new DepthStencilState(context.D3DDevice,
                                                                                                        new DepthStencilStateDescription()
                                                                                                            {
                                                                                                                IsDepthEnabled = false,
                                                                                                                IsStencilEnabled = false
                                                                                                            });
            context.D3DDevice.ImmediateContext.InputAssembler.InputLayout = context.InputLayout;
            context.D3DDevice.ImmediateContext.InputAssembler.PrimitiveTopology = PrimitiveTopology.TriangleList;
            context.D3DDevice.ImmediateContext.InputAssembler.SetVertexBuffers(0, new VertexBufferBinding(inputMesh.Vertices, inputMesh.AttributesSize, 0));
            var technique = _effect.GetTechniqueByIndex(0);
            technique.GetPassByIndex(0).Apply(context.D3DDevice.ImmediateContext);
            context.D3DDevice.ImmediateContext.Draw(_mesh.NumTriangles*3, 0);
            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(null, 0) });

            Changed = false;
        }

        private Mesh _mesh = new Mesh();
        private MeshCollector _meshCollector;
    }
}


