using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using SharpDX;
using SharpDX.D3DCompiler;
using SharpDX.Direct3D11;
using SharpDX.DXGI;
using SharpDX.Windows;
using Framefield.Core.Rendering;


namespace Framefield.Core.IDf7015bf5_43a0_4ec4_b4d8_da49426cf280
{
    public class Class_Sphere2Displace : OperatorPart.Function
    {
        public class Renderer : BaseRenderer
        {
            public override void SetupEffect(OperatorPartContext context) {
                base.SetupEffect(context);
                context.Effect.GetVariableByName("center").AsVector().Set(_center);
                context.Effect.GetVariableByName("radius").AsScalar().Set(_radius);
                context.Effect.GetVariableByName("strength").AsScalar().Set(_strength);
                context.Effect.GetVariableByName("bias").AsScalar().Set(_bias);
                
                context.Effect.GetVariableByName("center2").AsVector().Set(_center2);
                context.Effect.GetVariableByName("radius2").AsScalar().Set(_radius2);
                context.Effect.GetVariableByName("strength2").AsScalar().Set(_strength2);
                context.Effect.GetVariableByName("bias2").AsScalar().Set(_bias2);
            }

            public SharpDX.Vector2 _center;
            public float _radius;
            public float _strength;
            public float _bias;

            public SharpDX.Vector2 _center2;
            public float _radius2;
            public float _strength2;
            public float _bias2;
        }

        public Class_Sphere2Displace() {
            try {
                using (var bytecode = ShaderBytecode.CompileFromFile("assets-common/fx/Sphere2Displace.fx", "fx_5_0", ShaderFlags.None, EffectFlags.None, null, null))
                    _effect = new Effect(D3DDevice.Device, bytecode);
                _renderer = new Renderer();
            }
            catch (Exception ex) {
                Logger.Error(this,"error creating effect: {0}", ex.Message);
            }
        }



        public override void Dispose() {

            Utilities.DisposeObj(ref _effect);

        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            var Scene = inputs[0];//.Eval(context);
            var CenterX = inputs[1].Eval(context).Value;
            var CenterY = inputs[2].Eval(context).Value;
            _renderer._center = new SharpDX.Vector2(CenterX, CenterY);
            _renderer._radius = inputs[3].Eval(context).Value;
            _renderer._strength = inputs[4].Eval(context).Value;
            _renderer._bias = inputs[5].Eval(context).Value;

            var Center2X = inputs[6].Eval(context).Value;
            var Center2Y = inputs[7].Eval(context).Value;
            _renderer._center2 = new SharpDX.Vector2(Center2X, Center2Y);
            _renderer._radius2 = inputs[8].Eval(context).Value;
            _renderer._strength2 = inputs[9].Eval(context).Value;
            _renderer._bias2 = inputs[10].Eval(context).Value;


            var D3DDevice = context.D3DDevice;
            var subContext = new OperatorPartContext(context);
            try {
                subContext.Effect = _effect;
                subContext.InputLayout = context.Renderer.SceneDefaultInputLayout;
                subContext.Renderer = _renderer;

                Scene.Eval(subContext);
            }
            catch (Exception exception) {
                Logger.Error(this,"Load Effect error: {0}", exception.Message);
            }

            return context;
        }

        Effect _effect;
        Renderer _renderer;
    }
}

