using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;

namespace Framefield.Core.ID7919fb73_4f65_481a_95d2_210fdc9faa1e
{
    public class Class_SetSkySphere : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Scene = 0,
            Image = 1,
            Intensity = 2
        }
        //<<< _inputids

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _texture);
        }
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> __params
            var Scene = inputs[(int)InputId.Scene];
            var ImageInput = inputs[(int)InputId.Image];
            var Intensity = inputs[(int)InputId.Intensity].Eval(context).Value;
            //<<< __params

            if (ImageInput.Func.Changed)
            {
                var Image = ImageInput.Eval(context).Image;
                Dispose();
                if (Image != null)
                {
                    _texture = new ShaderResourceView(context.D3DDevice, Image);
                }
                ImageInput.Func.Changed = false;
            }

            var prevTexture0 = context.SkySphereSRV;
            if (_texture != null)
                context.SkySphereSRV = _texture;


            // FIXME: Intensity needs to be added to context
            Scene.Eval(context);

            context.SkySphereSRV = prevTexture0;
            return context;
        }

        ShaderResourceView _texture = null;
    }
}

