//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
using Framefield.Core.IDb03022e3_8b4f_4d33_b749_ef30a03ef098; // CurveProviderFunc
//<<< _using

namespace Framefield.Core.IDf7986d49_0fa6_455a_bae3_f0bd159cb849
{
    public class Class_SampleCurve : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Curve = 0,
            U = 1
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            X = 0,
            Y = 1,
            Z = 2,
            Radius = 3
        }
        //<<< _outputids
                        
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var Curve = inputs[(int)InputId.Curve].Eval(context).Dynamic;  // Needs to be checked for null!
            var U = inputs[(int)InputId.U].Eval(context).Value;
            //<<< _params

            _curve = Curve as ICurveProvider;
            if( _curve == null) {            
                Logger.Warn(this, "Can't render because curve is not connected or invalid");
                return context;
            }
            
            if(Changed) 
            {
                _p = _curve.SampleAt(U);
            }
            
            switch( (int)outputIdx) {
                case (int)OutputId.X: context.Value = _p.X; break;
                case (int)OutputId.Y: context.Value = _p.Y; break;
                case (int)OutputId.Z: context.Value = _p.Z; break;
                case (int)OutputId.Radius: context.Value = _p.W; break;
            }

            return context;
        }
        
        ICurveProvider _curve;
        Vector4 _p;
    }        
}

