//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID906848ad_8f5d_4116_b2da_12f525dda4bc
{
    public class Class_RotoZoomer : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            angleVal = 2,
            zoomValX = 3,
            scrollValX = 4,
            zoomValY = 5,
            scrollValY = 6,
            CenterX = 7,
            CenterY = 8
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var angleVal = inputs[(int)InputId.angleVal].Eval(context).Value;
            var zoomValX = inputs[(int)InputId.zoomValX].Eval(context).Value;
            var zoomValY = inputs[(int)InputId.zoomValY].Eval(context).Value;
            var zoomVal = new Vector2(zoomValX, zoomValY);
            var scrollValX = inputs[(int)InputId.scrollValX].Eval(context).Value;
            var scrollValY = inputs[(int)InputId.scrollValY].Eval(context).Value;
            var scrollVal = new Vector2(scrollValX, scrollValY);
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0,0,0,0));

                if (Image == null)
                    return;

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("angleVal").AsScalar().Set(angleVal);
                    _effect.GetVariableByName("zoomVal").AsVector().Set(new Vector2(zoomValX, zoomValY));
                    _effect.GetVariableByName("scrollVal").AsVector().Set(new Vector2(scrollValX, scrollValY));
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

