//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;

namespace Framefield.Core.ID0a0286c6_a72a_40d2_ae62_c46990e8dbca
{
    public class Class_RenderCubemapInContext : FXSourceCodeFunction, IFXSceneSourceCode
    {

        class Renderer : BaseRenderer
        {
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1
        }
        //<<< _inputids

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            //<<< _params

            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i) {
                    Compile(i);
                }
                _firstEval = false;
                Changed = true;
            }
            
            var cubeMapView = context.SkySphereSRV;
            _effect.GetVariableByName("CubeMap").AsShaderResource().SetResource(cubeMapView);

            using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer"))
            {
                context.Effect = _effect;
                context.Renderer = _renderer;
                Scene.Eval(context);
            }
            return context;
        }

        private Renderer _renderer = new Renderer();
    }
}


