//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
using Framefield.Core.IDb03022e3_8b4f_4d33_b749_ef30a03ef098; // CurveProviderFunc
//<<< _using

namespace Framefield.Core.ID1d70fe72_5457_4885_996c_58227cee40b8
{
    public class Class_RecordValueCurve : OperatorPart.Function, ICurveProvider
    {
        //>>> _inputids
        private enum InputId
        {
            U = 0,
            Duration = 1
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            This = 0,
            V = 1
        }
        //<<< _outputids
        
        public List<Vector4> GetPoints() 
        {
            var r = new List<Vector4>();
            for(int i = 0; i < _count; i++ ){
                var p = Utilities.PerlinNoise3(i,1,4); // _controlPoints.ToList();
                r.Add( new Vector4(p.X, p.Y, p.Z, 1));
            }
            return r;
        }
        
        
        int _count;
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var U = inputs[(int)InputId.U].Eval(context).Value;
            var Duration = inputs[(int)InputId.Duration].Eval(context).Value;
            //<<< _params
            
                        
            var p = Utilities.PerlinNoise3(U);
            switch( (int) outputIdx) {
                case (int)OutputId.V: context.Value= p.X; break;
                //case (int)OutputId.Y: context.Value= p.Y; break;
                //case (int)OutputId.Z: context.Value= p.Z; break;
                case (int)OutputId.This: context.Dynamic= this; break;
            }
                   
            //_count = (int)Count;                   
            return context;
        }

        public Vector4 SampleAt(double u) 
        {
            var p = Utilities.PerlinNoise3((float)u, 1, 2);
            //return new Vector4(p.X, p.Y, p.Z, 1);
            return new Vector4((float)u, p.Z, p.X, 1);
        }

        private double _lastTime;
    }        
}

