//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;

namespace Framefield.Core.ID714c7007_0342_48a0_a241_f46d95439c3c
{
    public class Class_RadialCutShader : FXSourceCodeFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            NumberOfCopies = 2,
            Id = 3,
            Rotate = 4,
            NearColorR = 5,
            NearColorG = 6,
            NearColorB = 7,
            NearColorA = 8,
            FarColorR = 9,
            FarColorG = 10,
            FarColorB = 11,
            FarColorA = 12,
            LineDistance = 13,
            LineWidth = 14,
            LineColorR = 15,
            LineColorG = 16,
            LineColorB = 17,
            LineColorA = 18,
            BackColorR = 19,
            BackColorG = 20,
            BackColorB = 21,
            BackColorA = 22,
            ColorBias = 23
        }
        //<<< _inputids
        #region Renderer
        public class Renderer : BaseRenderer
        {
            public override void SetupEffect(OperatorPartContext context)
            {
                base.SetupEffect(context);
                try
                {
                    SetupMaterialConstBuffer(context);
                    SetupFogSettingsConstBuffer(context);
                    SetupPointLightsConstBuffer(context);
                }
                catch (Exception e)
                {
                    Logger.Error(ParentFunc,"Error building constant buffer: {0} - Source: {1}", e.Message, e.Source);
                }
            }
            public OperatorPart.Function ParentFunc{get;set;}
        }
        #endregion

        public Class_RadialCutShader()
        {
            _renderer = new Renderer(){ParentFunc=this};
        }

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            // >>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var NumberOfCopies = inputs[(int)InputId.NumberOfCopies].Eval(context).Value;
            var Id = inputs[(int)InputId.Id].Eval(context).Value;
            var Rotate = inputs[(int)InputId.Rotate].Eval(context).Value;
            var NearColorR = inputs[(int)InputId.NearColorR].Eval(context).Value;
            var NearColorG = inputs[(int)InputId.NearColorG].Eval(context).Value;
            var NearColorB = inputs[(int)InputId.NearColorB].Eval(context).Value;
            var NearColorA = inputs[(int)InputId.NearColorA].Eval(context).Value;
            var NearColor = new Color4(NearColorR, NearColorG, NearColorB, NearColorA);
            var FarColorR = inputs[(int)InputId.FarColorR].Eval(context).Value;
            var FarColorG = inputs[(int)InputId.FarColorG].Eval(context).Value;
            var FarColorB = inputs[(int)InputId.FarColorB].Eval(context).Value;
            var FarColorA = inputs[(int)InputId.FarColorA].Eval(context).Value;
            var FarColor = new Color4(FarColorR, FarColorG, FarColorB, FarColorA);
            var LineDistance = inputs[(int)InputId.LineDistance].Eval(context).Value;
            var LineWidth = inputs[(int)InputId.LineWidth].Eval(context).Value;
            var Line = new Vector2(LineDistance, LineWidth);
            var LineColorR = inputs[(int)InputId.LineColorR].Eval(context).Value;
            var LineColorG = inputs[(int)InputId.LineColorG].Eval(context).Value;
            var LineColorB = inputs[(int)InputId.LineColorB].Eval(context).Value;
            var LineColorA = inputs[(int)InputId.LineColorA].Eval(context).Value;
            var LineColor = new Color4(LineColorR, LineColorG, LineColorB, LineColorA);
            var BackColorR = inputs[(int)InputId.BackColorR].Eval(context).Value;
            var BackColorG = inputs[(int)InputId.BackColorG].Eval(context).Value;
            var BackColorB = inputs[(int)InputId.BackColorB].Eval(context).Value;
            var BackColorA = inputs[(int)InputId.BackColorA].Eval(context).Value;
            var BackColor = new Color4(BackColorR, BackColorG, BackColorB, BackColorA);
            var ColorBias = inputs[(int)InputId.ColorBias].Eval(context).Value;
            // <<< _params

            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer"))
            {
                //_effect.GetVariableByName("Range").AsVector().Set(new Vector2(RangeX, RangeY));
                _effect.GetVariableByName("NumberOfCopies").AsScalar().Set(NumberOfCopies);
                _effect.GetVariableByName("Id").AsScalar().Set(Id);
                _effect.GetVariableByName("Rotate").AsScalar().Set(Rotate);
                context.Effect = _effect;
                context.Renderer = _renderer;
                Scene.Eval(context);
            }

            /*
            //>>> _setup
            {
                _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                _effect.GetVariableByName("NumberOfCopies").AsScalar().Set(NumberOfCopies);
                _effect.GetVariableByName("Id").AsScalar().Set(Id);
                _effect.GetVariableByName("Rotate").AsScalar().Set(Rotate);
                _effect.GetVariableByName("NearColor").AsVector().Set(new Vector4(NearColorR, NearColorG, NearColorB, NearColorA));
                _effect.GetVariableByName("FarColor").AsVector().Set(new Vector4(FarColorR, FarColorG, FarColorB, FarColorA));
                _effect.GetVariableByName("Line").AsVector().Set(new Vector2(LineDistance, LineWidth));
                _effect.GetVariableByName("LineColor").AsVector().Set(new Vector4(LineColorR, LineColorG, LineColorB, LineColorA));
                _effect.GetVariableByName("BackColor").AsVector().Set(new Vector4(BackColorR, BackColorG, BackColorB, BackColorA));
                _effect.GetVariableByName("ColorBias").AsScalar().Set(ColorBias);
            //<<< _setup            
            */
            return context;
        }

        Renderer _renderer;
    }
}


