//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDf8459c9c_fa5b_4e9f_94c1_49e621724db2
{
    public class Class_Pixelize : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            SizeX = 2,
            SizeY = 3,
            ShiftX = 4,
            ShiftY = 5
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var SizeX = inputs[(int)InputId.SizeX].Eval(context).Value;
            var SizeY = inputs[(int)InputId.SizeY].Eval(context).Value;
            var Size = new Vector2(SizeX, SizeY);
            var ShiftX = inputs[(int)InputId.ShiftX].Eval(context).Value;
            var ShiftY = inputs[(int)InputId.ShiftY].Eval(context).Value;
            var Shift = new Vector2(ShiftX, ShiftY);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Size").AsVector().Set(new Vector2(SizeX, SizeY));
                    _effect.GetVariableByName("Shift").AsVector().Set(new Vector2(ShiftX, ShiftY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

