using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID10824da0_7062_4ad5_aad6_cdd187796b07
{
    public class Class_ParamRangeSelector : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Min = 0,
            Default = 1,
            Max = 2,
            Select = 3
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Min = inputs[(int)InputId.Min].Eval(context).Value;
            var Default = inputs[(int)InputId.Default].Eval(context).Value;
            var Max = inputs[(int)InputId.Max].Eval(context).Value;
            var Select = inputs[(int)InputId.Select].Eval(context).Value;
            //<<< _params
            
            if(Select <= 0) {
                context.Value = Default+(Default-Min) * Select;
            }
            else {
                context.Value = Default+(Max-Default) * Select;            
            }

            return context;
        }
    }
}

