//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.IO;

namespace Framefield.Core.IDb9c5480d_835e_4cc9_b1e2_477ef584630f
{
    public class Class_LoadImageFromSequence : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            ImagePath = 0
        }
        //<<< _inputids

        //>>> _outputids
        private enum OutputId
        {
            Image = 0,
            SizeX = 1,
            SizeY = 2
        }
        //<<< _outputids

        public override void Dispose() {
            Utilities.DisposeObj(ref _imageTexture);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var ImagePath = inputs[(int)InputId.ImagePath].Eval(context).Text;
            //<<< _params

            if (ImagePath == _lastImage)
                Changed = false;

            _lastImage = ImagePath;

            if (Changed)
            {
                Dispose();
                if (File.Exists(ImagePath))
                {
                    //_imageResource = ResourceManager.ReadImage(ImagePath);
                    _imageTexture = SharpDX.Direct3D11.Resource.FromFile<Texture2D>(D3DDevice.Device, ImagePath); 
                    //Texture2D.ToFile(context.D3DDevice.ImmediateContext, _imageTexture, ImageFileFormat.Dds, ImagePath + ".dds");
                    _size = new Vector2(_imageTexture.Description.Width, _imageTexture.Description.Height); 
                    //Logger.Info("loaded:" + ImagePath);
                }
                else
                {
                    Logger.Error(this,"Imagefile not found '{0}'", ImagePath);
                }

                //somehow this will cause an exception
                //FileInfo fi = new FileInfo(ImagePath);
                //var depthFilename = fi.DirectoryName + "\\" + Path.GetFileNameWithoutExtension(fi.Name) + "_depth.dds";
                //Logger.Error(this,"'{0}'", depthFilename);
                //if (File.Exists(depthFilename))
                //{
                //    _depthImageResource = ResourceManager.ReadImage(depthFilename);
                //}
                Changed = false;
            }

            if (_imageTexture != null)
            {
                switch ((OutputId)outputIdx)
                {
                    case OutputId.Image:
                        context.Image = _imageTexture;
                        break;
                    case OutputId.SizeX:
                        context.Value = _size.X;
                        break;
                    case OutputId.SizeY:
                        context.Value = _size.Y;
                        break;
                }
            }
            else
            {
                switch (outputIdx)
                {
                    case (int)OutputId.Image:
                        context.Image = null;
                        context.DepthImage = null;
                        break;
                    case (int)OutputId.SizeX:
                        context.Value = 0;
                        break;
                    case (int)OutputId.SizeY:
                        context.Value = 0;
                        break;
                }
            }

            return context;
        }

        //ImageResource _imageResource;
        //ImageResource _depthImageResource;
        Texture2D _imageTexture;
        Vector2 _size;
        String _lastImage = String.Empty;
    }
}

