//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDaae3517a_3976_4cf4_9ff1_a539ec43b77c
{
    public class Class_HueOffset : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            AmpDist = 2,
            Gamma = 3,
            rgbDistX = 4,
            rgbDistY = 5,
            rgbDistZ = 6
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var AmpDist = inputs[(int)InputId.AmpDist].Eval(context).Value;
            var Gamma = inputs[(int)InputId.Gamma].Eval(context).Value;
            var rgbDistX = inputs[(int)InputId.rgbDistX].Eval(context).Value;
            var rgbDistY = inputs[(int)InputId.rgbDistY].Eval(context).Value;
            var rgbDistZ = inputs[(int)InputId.rgbDistZ].Eval(context).Value;
            var rgbDist = new Vector3(rgbDistX, rgbDistY, rgbDistZ);
            //<<< _params
            
            if(Image == null)
                return context;


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("AmpDist").AsScalar().Set(AmpDist);
                    _effect.GetVariableByName("Gamma").AsScalar().Set(Gamma);
                    _effect.GetVariableByName("rgbDist").AsVector().Set(new Vector3(rgbDistX, rgbDistY, rgbDistZ));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

