//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID6b9fd238_bd65_4717_9bb9_d38612ce9f1b
{
    public class Class_GetCurrentCamPosition : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
        }
        //<<< _inputids
        //>>> _outputids
        private enum OutputId
        {
            Scene = 0,
            x = 1,
            y = 2,
            z = 3
        }
        //<<< _outputids


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            
            //<<< _params
            
            switch(outputIdx) {
                case (int)OutputId.Scene:
                    var m = context.WorldToCamera;
                    m.Invert();
                    _lastPosition = m.Row4;            
                    break;
                    
                case (int)OutputId.x: 
                    context.Value = _lastPosition.X;
                    break;
            
                case (int)OutputId.y: 
                    context.Value = _lastPosition.Y;
                    break;
            
                case (int)OutputId.z: 
                    context.Value = _lastPosition.Z;
                    break;                
            }
           
            return context;
        }
        
        private Vector4 _lastPosition;
    }
}

