//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDa06919b3_0638_4ad7_a30c_2296c0e5d500
{
    public class Class_FindFlanksInValueRange : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            AnimatedValue = 0,
            TimeRangeStart = 1,
            TimeRangeEnd = 2,
            TimeResolution = 3,
            ResampleTrigger = 4
        }
        //<<< _inputids
        
        
        

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var AnimatedValue = inputs[(int)InputId.AnimatedValue].Eval(context).Value;
            var TimeRangeStart = inputs[(int)InputId.TimeRangeStart].Eval(context).Value;
            var TimeRangeEnd = inputs[(int)InputId.TimeRangeEnd].Eval(context).Value;
            var TimeRange = new Vector2(TimeRangeStart, TimeRangeEnd);
            var TimeResolution = inputs[(int)InputId.TimeResolution].Eval(context).Value;
            var ResampleTrigger = inputs[(int)InputId.ResampleTrigger].Eval(context).Value;
            //<<< _params
            
            
            if(Changed) 
            {
            
                var needsResampling =  (TimeRangeStart != _startTime)
                                    || (TimeRangeEnd != _endTime)
                                    || (TimeResolution != _timeResolution)
                                    || ResampleTrigger > 0.5f;
                
                if( needsResampling) 
                {
                    _startTime = TimeRangeStart;
                    _endTime = TimeRangeEnd;
                    _timeResolution = TimeResolution;
                    UpdateSampleCount();
                    Logger.Info(this, "Resample " + _sampleCount + " Samples");
                    
                    var valueInput = inputs[(int)InputId.AnimatedValue];                    
                    FindFlankIndexesInValue(valueInput,  context);                                        
                }

                Changed =false;
            }
            
            var sampleIndex = (int)Utilities.Clamp( (context.Time - _startTime) * TimeResolution, 0, _sampleCount-1);
            context.Value = _bufferA[sampleIndex];
            return context;
        }
        

        
        
        private void UpdateSampleCount() 
        {
            _sampleCount = (int) Utilities.Clamp( (_endTime - _startTime) * _timeResolution, 2, MAX_SAMPLE_STEPS);
            if( _bufferA == null ||  _bufferA.Length != _sampleCount) 
            {
                _bufferA = new float[_sampleCount];
                //_bufferB = new float[_sampleCount];
            }        
        }


        private void FindFlankIndexesInValue(OperatorPart valueInput, OperatorPartContext context) 
        {
            var previousTime = context.Time;

            OperatorPart.ChangedPropagationEnabled = false;
            
            var invalidator = new OperatorPart.InvalidateTimeAccessors();
            var lastV = 0f;
            var valueChangeIndex = 0f;
            
            for (var i = 0; i < _sampleCount - 1; i++)
            {   
                var f = i/(float)_sampleCount;
                var t = Utilities.Lerp(_startTime, _endTime, f);                 
                context.Time = t;
                var v = valueInput.Eval(context).Value;
                if( Math.Abs( v - lastV) > 0.001f) {
                    valueChangeIndex++;
                }
                lastV = v;
                _bufferA[i] = valueChangeIndex;

                // Invalidate all time accessors
                valueInput.TraverseWithFunction(null, invalidator);                                        
            }
            
            OperatorPart.ChangedPropagationEnabled = true;
            context.Time = previousTime;            
            valueInput.TraverseWithFunction(null, invalidator);          
        }
        
        
        private float _startTime;
        private float _endTime;
        private float _timeResolution;
        private const int MAX_SAMPLE_STEPS = 100000;
        private int _sampleCount= 1;
        private int _smoothSamples = 2;
        
        private float[] _bufferA;
    }
}

