//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;
using System.Dynamic;
using System.IO;


namespace Framefield.Core.ID77956284_3099_4765_aac3_ea72e1108e75
{
    public class Class_DynamicToString : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Input = 0,
            Filter = 1
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Input = inputs[(int)InputId.Input].Eval(context).Dynamic; 
            if (Input == null)
            {
                context.Text = String.Empty;
                return context;
            }
            //<<< params

            using (var stringWriter = new StringWriter())
            using (var jsonTextWriter = new JsonTextWriter(stringWriter) 
                                            {
                                                QuoteName = false,
                                                Formatting = Formatting.Indented
                                            })
            {
                _serializer.Serialize(jsonTextWriter, Input);
                context.Text = stringWriter.ToString();
            }

            return context;
        }

        JsonSerializer _serializer = new JsonSerializer();
    }
}

