//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID873a7566_b423_4559_a705_a280928df27d
{
    public class Class_DragonSpiralTrangle : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            iTime = 1,
            TriAngle = 2,
            ViewMagnify = 3,
            LogZoom = 4,
            Method = 5,
            BrightUV = 6,
            FFT = 7,
            CenterX = 8,
            CenterY = 9
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var iTime = inputs[(int)InputId.iTime].Eval(context).Value;
            var TriAngle = inputs[(int)InputId.TriAngle].Eval(context).Value;
            var ViewMagnify = inputs[(int)InputId.ViewMagnify].Eval(context).Value;
            var LogZoom = inputs[(int)InputId.LogZoom].Eval(context).Value;
            var Method = inputs[(int)InputId.Method].Eval(context).Value;
            var BrightUV = inputs[(int)InputId.BrightUV].Eval(context).Value;
            var FFT = inputs[(int)InputId.FFT].Eval(context).Value;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            //<<< _params
            
//            if(Image == null)
//                return context;

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("iTime").AsScalar().Set(iTime);
                    _effect.GetVariableByName("TriAngle").AsScalar().Set(TriAngle);
                    _effect.GetVariableByName("ViewMagnify").AsScalar().Set(ViewMagnify);
                    _effect.GetVariableByName("LogZoom").AsScalar().Set(LogZoom);
                    _effect.GetVariableByName("Method").AsScalar().Set(Method);
                    _effect.GetVariableByName("BrightUV").AsScalar().Set(BrightUV);
                    _effect.GetVariableByName("FFT").AsScalar().Set(FFT);
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

