//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDefab105f_9f5b_4ba6_aaef_a95277ae7c72
{
    public class Class_DitherPalette : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            ResolutionX = 2,
            ResolutionY = 3,
            Pallette = 4
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var ResolutionX = inputs[(int)InputId.ResolutionX].Eval(context).Value;
            var ResolutionY = inputs[(int)InputId.ResolutionY].Eval(context).Value;
            var Resolution = new Vector2(ResolutionX, ResolutionY);
            var Pallette = (int) inputs[(int)InputId.Pallette].Eval(context).Value;
            //<<< _params
            
            if(Image == null)
                return context;


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Resolution").AsVector().Set(new Vector2(ResolutionX, ResolutionY));
                    _effect.GetVariableByName("Pallette").AsScalar().Set(Pallette);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

