//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID91c62c60_293d_42ef_878b_4d4565258434
{
    public class Class_Displace9Slices : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            CenterImage = 1,
            OuterSizeX = 2,
            OuterSizeY = 3,
            CornerRadius = 4
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var CenterImage = inputs[(int)InputId.CenterImage].Eval(context).Image; if (CenterImage == null) return context;
            var OuterSizeX = inputs[(int)InputId.OuterSizeX].Eval(context).Value;
            var OuterSizeY = inputs[(int)InputId.OuterSizeY].Eval(context).Value;
            var OuterSize = new Vector2(OuterSizeX, OuterSizeY);
            var CornerRadius = inputs[(int)InputId.CornerRadius].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var CenterImageView = new ShaderResourceView(context.D3DDevice, CenterImage))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("CenterImage").AsShaderResource().SetResource(CenterImageView);
                    _effect.GetVariableByName("OuterSize").AsVector().Set(new Vector2(OuterSizeX, OuterSizeY));
                    _effect.GetVariableByName("CornerRadius").AsScalar().Set(CornerRadius);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

