using System.Collections.Generic;
using Framefield.Core.Rendering;

namespace Framefield.Core.ID059ca5d8_90f5_4f64_8e88_d293a4fabb24
{
    public class Class_DefaultShader : FXSourceCodeFunction, IFXSceneSourceCode
    {
        public Class_DefaultShader() {
            _renderer = new DefaultRenderer();
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            if (_firstEval) {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            var Scene = inputs[1];

            using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer")) {
                context.Effect = _renderer.SceneDefaultEffect;
                context.Renderer = _renderer;

                Scene.Eval(context);
            }

            return context;
        }

        DefaultRenderer _renderer;
    }
}


