//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;
using SharpDX.DXGI;


namespace Framefield.Core.IDd5d66570_6601_478f_b1b5_e9b21b6667ad
{
    public class Class_CubeMapFromTexture : FXSourceCodeFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Resolution = 2,
            Orientation = 3
        }
        //<<< _inputids

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _prefilteredCubeMap);
            Utilities.DisposeObj(ref _cubeMapRTV);
            Utilities.DisposeObj(ref _rasterizerState);
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var Resolution = inputs[(int)InputId.Resolution].Eval(context).Value;
            var Orientation = inputs[(int)InputId.Orientation].Eval(context).Value;
            //<<< _params


            if(Image == null) {
                return context;
            }

            if (_effect == null)
            {
                for (int i = 0; i < NumCodes(); ++i) {
                    Compile(i);
                }
                Changed = true;
            }
            
            var res = (int)Math.Max(1,Resolution);
            
            var cubeMapSize = new Vector2(res, res);

            if (_prefilteredCubeMap == null)
            {
                var cubeMapDesc = new Texture2DDescription
                {
                    BindFlags = BindFlags.ShaderResource | BindFlags.RenderTarget,
                    Format = SharpDX.DXGI.Format.R16G16B16A16_Float,
                    Width = (int)cubeMapSize.X,
                    Height = (int)cubeMapSize.Y,
                    MipLevels = 9,
                    SampleDescription = new SampleDescription(1,0),
                    Usage = ResourceUsage.Default,
                    OptionFlags = ResourceOptionFlags.TextureCube | ResourceOptionFlags.GenerateMipMaps,
                    CpuAccessFlags = CpuAccessFlags.None,
                    ArraySize = 6
                };

                _prefilteredCubeMap = new Texture2D(D3DDevice.Device, cubeMapDesc);
                _cubeMapRTV = new RenderTargetView(D3DDevice.Device, _prefilteredCubeMap);
                
                var rastDesc = new RasterizerStateDescription
                                   {
                                       FillMode = FillMode.Solid,
                                       CullMode = CullMode.None,
                                       IsDepthClipEnabled = false
                                   };
                _rasterizerState = new RasterizerState(D3DDevice.Device, rastDesc);    
            }

            if (Changed)
            {
                var prevEffect = context.Effect;
    
                var prevRTV = context.RenderTargetView;
                var prevDTV = context.DepthStencilView;
    
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image)) {
                    context.D3DDevice.ImmediateContext.OutputMerger.SetTargets(_cubeMapRTV, null);
                    context.D3DDevice.ImmediateContext.OutputMerger.BlendState = OperatorPartContext.DefaultRenderer.DisabledBlendState;
                    context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState = OperatorPartContext.DefaultRenderer.DisabledDepthStencilState;
                    
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    SetScalar("Orientation", Orientation / 180f * 3.141578f );
                    /*
                    _effect.GetVariableByName("SunPosition").AsVector().Set(SunPosition);
                    _effect.GetVariableByName("SkyColor").AsVector().Set(SkyColor);
                    _effect.GetVariableByName("SunColor").AsVector().Set(SunColor);
                    _effect.GetVariableByName("GroundColor").AsVector().Set(GroundColor);
                    _effect.GetVariableByName("HorizonBlur").AsScalar().Set(HorizonBlur);
                    _effect.GetVariableByName("HorizonOffset").AsScalar().Set(HorizonOffset);           
                    _effect.GetVariableByName("HorizonColor").AsVector().Set(HorizonColor);           
                    */
                        
                    var viewport = new ViewportF(0.0f, 0.0f, cubeMapSize.X, cubeMapSize.Y);
                    context.D3DDevice.ImmediateContext.Rasterizer.SetViewports(new [] { viewport });
                    context.D3DDevice.ImmediateContext.Rasterizer.State = _rasterizerState;
                    context.D3DDevice.ImmediateContext.InputAssembler.InputLayout = context.InputLayout;
                    context.D3DDevice.ImmediateContext.InputAssembler.PrimitiveTopology = SharpDX.Direct3D.PrimitiveTopology.TriangleList;
                    context.D3DDevice.ImmediateContext.InputAssembler.SetVertexBuffers(0, new VertexBufferBinding(null, 0, 0));
        
                    var technique = _effect.GetTechniqueByIndex(0);
                    technique.GetPassByIndex(0).Apply(context.D3DDevice.ImmediateContext);
                    context.D3DDevice.ImmediateContext.Draw(6, 0);
    
                    context.D3DDevice.ImmediateContext.OutputMerger.SetTargets(context.DepthStencilView, context.RenderTargetView);
                }

                
                using (var srv = new ShaderResourceView(context.D3DDevice, _prefilteredCubeMap))
                {
                    Logger.Info(this, "generate mips");
                    context.D3DDevice.ImmediateContext.GenerateMips(srv);
                }
                Changed = false;
            }
            
            context.Image = _prefilteredCubeMap;
            return context;
        }

        Texture2D _prefilteredCubeMap;
        RenderTargetView _cubeMapRTV;
        RasterizerState _rasterizerState;
    }
}


