//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID0521933e_bcb3_484f_841d_c368a61fbe53
{
    public class Class_CelShading : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            FilterSize = 2,
            ColorLevels = 3,
            EdgeFilterSize = 4,
            EdgeTreshold = 5
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var FilterSize = inputs[(int)InputId.FilterSize].Eval(context).Value;
            var ColorLevels = inputs[(int)InputId.ColorLevels].Eval(context).Value;
            var EdgeFilterSize = inputs[(int)InputId.EdgeFilterSize].Eval(context).Value;
            var EdgeTreshold = inputs[(int)InputId.EdgeTreshold].Eval(context).Value;
            //<<< _params
            
            if(Image == null)
                return context;


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("FilterSize").AsScalar().Set(FilterSize);
                    _effect.GetVariableByName("ColorLevels").AsScalar().Set(ColorLevels);
                    _effect.GetVariableByName("EdgeFilterSize").AsScalar().Set(EdgeFilterSize);
                    _effect.GetVariableByName("EdgeTreshold").AsScalar().Set(EdgeTreshold);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

