//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID5b6351fb_c9f4_412c_b4f9_7f4cf652e083
{
    public class Class_BlurValue : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            AnimatedValue = 0,
            SampleCount = 1,
            SampleTime = 2
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var AnimatedValue = inputs[(int)InputId.AnimatedValue].Eval(context).Value;
            var SampleCount = inputs[(int)InputId.SampleCount].Eval(context).Value;
            var SampleTime = inputs[(int)InputId.SampleTime].Eval(context).Value;
            //<<< _params
            
            
            if(Changed) 
            {
                
                int _maxSteps = (int) Utilities.Clamp(SampleCount, 2, 20);
                var valueInput = inputs[(int)InputId.AnimatedValue];
                var previousTime = context.Time;
    
                OperatorPart.ChangedPropagationEnabled = false;
                _sum = 0f;
                var invalidator = new OperatorPart.InvalidateTimeAccessors();
                
                float lastV = 0;
                
                for (var i = 0; i < _maxSteps - 1; i++)
                {   
                    var f= i/(float)_maxSteps;
                    
                    // Invalidate all time accessors
                    valueInput.TraverseWithFunction(null, invalidator);                                        
                    var f1= i/(float)_maxSteps;                    
                    context.Time = previousTime + (f1 - 0.5f) * SampleTime;
                    var v1= valueInput.Eval(context).Value;

                    // Invalidate all time accessors
                    valueInput.TraverseWithFunction(null, invalidator);                                        
                    var f2= i/(float)_maxSteps;                    
                    context.Time = previousTime + (f2 + 0.5f) * SampleTime;
                    var v2= valueInput.Eval(context).Value;
                                        
                    var interpolated = Utilities.Lerp( v1, v2, 1-f);                                                
                    _sum+= interpolated;                    
                }
                _sum /= _maxSteps;
                
                OperatorPart.ChangedPropagationEnabled = true;
                
                valueInput.TraverseWithFunction(null, invalidator);                    

                context.Time = previousTime;
                context.Value = _sum;
                Changed =false;
            }
            
            
            

            return context;
        }

        private float _targetValue = 0;
        private float _sum = 0;
        private SmoothInterpolator _smoothInterpolator = new SmoothInterpolator(defaultValue:0, acceleration:0.4, delta:0.001);
    }
}

