//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDc694065e_55d0_42ac_aef5_4f31675de5b8
{
    public class Class_BlendImageRamp : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            ColorAR = 1,
            ColorAG = 2,
            ColorAB = 3,
            ColorAA = 4,
            ColorBR = 5,
            ColorBG = 6,
            ColorBB = 7,
            ColorBA = 8,
            CenterX = 9,
            CenterY = 10,
            Angle = 11,
            Feather = 12,
            ImageA = 13,
            Samples = 14,
            BlurStrength = 15,
            Intensity = 16,
            Width = 17,
            Offset = 18
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var ColorAR = inputs[(int)InputId.ColorAR].Eval(context).Value;
            var ColorAG = inputs[(int)InputId.ColorAG].Eval(context).Value;
            var ColorAB = inputs[(int)InputId.ColorAB].Eval(context).Value;
            var ColorAA = inputs[(int)InputId.ColorAA].Eval(context).Value;
            var ColorA = new Color4(ColorAR, ColorAG, ColorAB, ColorAA);
            var ColorBR = inputs[(int)InputId.ColorBR].Eval(context).Value;
            var ColorBG = inputs[(int)InputId.ColorBG].Eval(context).Value;
            var ColorBB = inputs[(int)InputId.ColorBB].Eval(context).Value;
            var ColorBA = inputs[(int)InputId.ColorBA].Eval(context).Value;
            var ColorB = new Color4(ColorBR, ColorBG, ColorBB, ColorBA);
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            var Feather = inputs[(int)InputId.Feather].Eval(context).Value;
            var ImageA = inputs[(int)InputId.ImageA].Eval(context).Image; // Needs to be checked for null!
            var Samples = inputs[(int)InputId.Samples].Eval(context).Value;
            var BlurStrength = inputs[(int)InputId.BlurStrength].Eval(context).Value;
            var Intensity = inputs[(int)InputId.Intensity].Eval(context).Value;
            var Width = inputs[(int)InputId.Width].Eval(context).Value;
            var Offset = inputs[(int)InputId.Offset].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));
                
                if( ImageA == null )
                    return;

                //>>> _setup
                using (var ImageAView = new ShaderResourceView(context.D3DDevice, ImageA))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("ColorA").AsVector().Set(new Vector4(ColorAR, ColorAG, ColorAB, ColorAA));
                    _effect.GetVariableByName("ColorB").AsVector().Set(new Vector4(ColorBR, ColorBG, ColorBB, ColorBA));
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                    _effect.GetVariableByName("Feather").AsScalar().Set(Feather);
                    _effect.GetVariableByName("ImageA").AsShaderResource().SetResource(ImageAView);
                    _effect.GetVariableByName("Samples").AsScalar().Set(Samples);
                    _effect.GetVariableByName("BlurStrength").AsScalar().Set(BlurStrength);
                    _effect.GetVariableByName("Intensity").AsScalar().Set(Intensity);
                    _effect.GetVariableByName("Width").AsScalar().Set(Width);
                    _effect.GetVariableByName("Offset").AsScalar().Set(Offset);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



