//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Dynamic;
using Framefield.Core.OperatorPartTraits;

namespace Framefield.Core.IDbba514be_5d8b_437e_a198_7c52a347dc95
{
    public class Class_BlendCameras : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            Camera = 1,
            CameraIndex = 2,
            SoftBlend = 3
        }
        //<<< _inputids
        //>>> _outputids
        private enum OutputId
        {
            Output = 0,
            Camera = 1
        }
        //<<< _outputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params_OFF
            var SceneInput = inputs[(int)InputId.SceneInput];
            var cameraInput = inputs[(int)InputId.Camera];  // Needs to be checked for null!
            var CameraIndex = inputs[(int)InputId.CameraIndex].Eval(context).Value;
            var SoftBlend = inputs[(int)InputId.SoftBlend].Eval(context).Value;
            //<<< _params_OFF



            var prevTransform = context.WorldToCamera;
            var prevCamProj = context.CameraProjection;

            if (cameraInput != null)
            {
                var camCount = (int)cameraInput.Connections.Count;
                
                
                int indexA= (int)(CameraIndex % camCount);
                int indexB = (int)((CameraIndex + 1) % camCount);
            
                try {
                    var dynamicResultA = cameraInput.Connections[indexA].Eval(context).Dynamic;  // Needs to be checked for null!
                    var dynamicResultB = cameraInput.Connections[indexB].Eval(context).Dynamic;  // Needs to be checked for null!                    

                    var camA = dynamicResultA.This as ICameraProvider;
                    var camB = dynamicResultB.This as ICameraProvider;
                    if(camA != null && camB != null) 
                    {
                        float f = CameraIndex % 1;
                        f = Utilities.SmoothStep( Utilities.Clamp( f / SoftBlend, 0.001f,1) );
                        //Logger.Info("Count:" + camCount+ " f" + ff );    
                        var target = Vector3.Lerp( camA.GetLastTarget(), camB.GetLastTarget(), f); 
                        var position = Vector3.Lerp( camA.GetLastPosition(), camB.GetLastPosition(), f); 
                        var roll = Utilities.Lerp( (float)camA.GetLastRoll(), (float)camB.GetLastRoll(), f);
                        var fov = Utilities.Lerp( (float)camA.GetLastFOV(), (float)camB.GetLastFOV(), f);
                        context.WorldToCamera = CalcWorldToCamera( position, target, roll, Vector3.Zero, Vector3.Zero);
                        context.CameraProjection = camA.GetLastCameraToView();
                    }
                }
                catch (Exception e) {
                }
            }
            
            /*
            switch (outputIdx)
            {
                case (int)OutputId.Output:
                    SceneInput.Eval(context);
                    break;
                case (int)OutputId.This:
                    dynamic obj = new ExpandoObject();
                    obj.This = this;
                    context.Dynamic = obj;
                    break;
            }*/            

            SceneInput.Eval(context);

            context.CameraProjection = prevCamProj;
            context.WorldToCamera = prevTransform;

            return context;
        }
        
        
        Matrix CalcWorldToCamera(Vector3 position, Vector3 target, float roll, Vector3 positionOffset, Vector3 rotateOffset)
        {
            var worldToCamera = Matrix.LookAtLH(position, target, new Vector3(0, 1, 0));
            var rollRotation = Matrix.RotationAxis(new Vector3(0, 0, 1), -(float)roll);
            var additionalTranslation = Matrix.Translation(positionOffset);
            var additionalRotation = Matrix.RotationYawPitchRoll((float)Utilities.DegreeToRad(rotateOffset.Y),
                                                                 (float)Utilities.DegreeToRad(rotateOffset.X),
                                                                 (float)Utilities.DegreeToRad(rotateOffset.Z));

            return worldToCamera*rollRotation*additionalTranslation*additionalRotation;
        }        
    }
}

