//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID1a6a10ff_54e3_43ae_a47b_aac66de0d654
{
    public class Class_3DVoronoi : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            iTime = 1,
            turnSpeed = 2,
            saturation = 3,
            outline = 4,
            dotSize = 5,
            FFT = 6,
            CenterX = 7,
            CenterY = 8,
            eyeX = 9,
            eyeY = 10,
            eyeZ = 11
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var iTime = inputs[(int)InputId.iTime].Eval(context).Value;
            var turnSpeed = inputs[(int)InputId.turnSpeed].Eval(context).Value;
            var saturation = inputs[(int)InputId.saturation].Eval(context).Value;
            var outline = inputs[(int)InputId.outline].Eval(context).Value;
            var dotSize = inputs[(int)InputId.dotSize].Eval(context).Value;
            var FFT = inputs[(int)InputId.FFT].Eval(context).Value;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var eyeX = inputs[(int)InputId.eyeX].Eval(context).Value;
            var eyeY = inputs[(int)InputId.eyeY].Eval(context).Value;
            var eyeZ = inputs[(int)InputId.eyeZ].Eval(context).Value;
            var eye = new Vector3(eyeX, eyeY, eyeZ);
            //<<< _params
            
//            if(Image == null)
//                return context;

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("iTime").AsScalar().Set(iTime);
                    _effect.GetVariableByName("turnSpeed").AsScalar().Set(turnSpeed);
                    _effect.GetVariableByName("saturation").AsScalar().Set(saturation);
                    _effect.GetVariableByName("outline").AsScalar().Set(outline);
                    _effect.GetVariableByName("dotSize").AsScalar().Set(dotSize);
                    _effect.GetVariableByName("FFT").AsScalar().Set(FFT);
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("eye").AsVector().Set(new Vector3(eyeX, eyeY, eyeZ));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

