;::::::::::::::::::::::::::::::::::::::::::::::::::
;:                                               ::
;:                 [ DEEP TRIP ]                 ::
;:                                               ::
;:                256-byte intro                 ::
;:                                               ::
;:-----------------------------------------------::
;:                                               ::
;:               (c) 2019 by Jin X               ::
;:                                               ::
;:  Telegram: @jinxonik / e-mail: jin_x@list.ru  ::
;:                                               ::
;::::::::::::::::::::::::::::::::::::::::::::::::::

;-----------------------------------------------------------------------------------------------------------------------
;-- MAIN SOURCE --------------------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------------------------------

; DON'T TOUCH ALL SETTINGS BELOW !!!
scr_width	=	320
scr_height	=	200

; Palette settings
if	pal_start_green
  pal_more_first =	pal_more_green
else
  pal_more_first =	- pal_more_green
end if ; pal_start_green

if	pal_more_first = 0
  pal_first_val	=	max_frac_color		; initial value for fractal palette setup
else if	pal_more_first = 1
  pal_first_val	=	max_frac_color * 7 / 6
else if	pal_more_first = 2
  pal_first_val	=	max_frac_color * 4 / 3
else if	pal_more_first = 3
  pal_first_val	=	max_frac_color * 3 / 2
else if	pal_more_first = 4
  pal_first_val	=	max_frac_color * 7 / 4
else if	pal_more_first = 5
  pal_first_val	=	0x3F * 2		; maximal
else if	pal_more_first = -1
  pal_first_val	=	max_frac_color * 5 / 6
else if	pal_more_first = -2
  pal_first_val	=	max_frac_color * 2 / 3
else if	pal_more_first = -3
  pal_first_val	=	max_frac_color * 1 / 2
else if	pal_more_first = -4
  pal_first_val	=	max_frac_color * 1 / 4
else if	pal_more_first = -5
  pal_first_val	=	0			; minimal
end if ; pal_more_first

if	max_frac_color > 0x40 | pal_no_hicontr
  pal_first_val	=	pal_first_val / 2
  pal_chg_double =	0			; change fractal palette value by 1
else ; max_frac_color <= 0x3F
  pal_chg_double =	1			; change fractal palette value by 2
end if ; max_frac_color...

if	pal_first_val > 0x3F
  pal_first_val	=	0x3F
else if	pal_first_val < (max_frac_color - 1) * (1+pal_chg_double) - 0x40
  pal_first_val	=	(max_frac_color - 1) * (1+pal_chg_double) - 0x40
end if ; pal_first_val

if	(~ flame_inside | (interleave & ~ il_duplicate)) & allow_col_blink = 1
  allow_col_blink =	0
end if ; ~ flame_inside

if	allow_col_blink = 1
  pal_corr	=	1
else ; allow_col_blink <> 1
  pal_corr	=	0
end if ; allow_col_blink

pal_first_val	=	pal_first_val + pal_corr * (1+pal_chg_double)

if	~ pal_start_green
  pal_first_val	=	not pal_first_val
end if ; ~ pal_start_green

; Fractal settings
if	fractal2_param < 3
  julia2_sub	=	1			; direction of Julia fractal dynamics: 1-use fsub with scale (increase parameter value)
else ; fractal2_param >= 3
  julia2_sub	=	0			; direction of Julia fractal dynamics: 0-use fadd with scale (decrease parameter value)
end if ; fractal2_param				; [the final point (frame) is the same]

; Sound settings
if	play_sound
  if	real_sys_compat
    real_sys_sound =	1
    dosbox_sound =	0
  else ; ~ real_sys_compat
    real_sys_sound =	0
    dosbox_sound =	1
  end if ; real_sys_compat
else ; ~ play_sound
  real_sys_sound =	0
  dosbox_sound	=	0
end if ; play_sound

pit_freq	=	1193182			; PIT counter frequency

sound_counter	=	0x7C			; address of sound counter for real_sys_sound
if	~ sound_cnt32
  sound_counter	=	sound_counter + 2
end if ; ~ sound_cnt32

; Interleave settings
if	interleave = 2
  width_div	=	2
  height_div	=	2
  size_div	=	4
else ; interleave <> 2
  if	interleave
    width_div	=	2
  else
    width_div	=	1
  end if ; interleave
  height_div	=	1
  size_div	=	2
end if ; interleave = ...

; Memory settings
memory_needed	=	0x1000			; in paragraphs
if	double_buffer
  memory_needed	=	memory_needed + (scr_width*scr_height+15)/16
  if	crunch_level > 0
    memory_needed =	memory_needed + 0x300
  end if ; crunch_level > 0
end if ; double_buffer

; Interrupt settings
if	use_int8
  int_no	=	8
else ; ~ use_int8
  int_no	=	0x1C
end if ; use_int8

; Variables settings
rel		equ	bx
match =0:=1, real_sys_compat:play_sound { rel equ si } ; rel is redefined only if real_sys_compat = 0 & play_sound = 1

match =bx, rel
{
  il_temp_reg	equ	si
  flame_buf	equ	rel+(_flame_buf-data_rel)
} ; match

match =si, rel
{
  il_temp_reg	equ	bp
  flame_buf	equ	_flame_buf
} ; match

temp		equ	rel
angle		equ	rel+4
if	~ (real_sys_sound & allow_exit & restore_int)
  _save_int_ofs	=	data_rel+8
  _save_int_seg	=	data_rel+10
end if ; ~ (real_sys_sound & allow_exit & restore_int)
save_int_ofs	equ	rel+(_save_int_ofs-data_rel)
save_int_seg	equ	rel+(_save_int_seg-data_rel)
delta_a		equ	rel+(_delta_a-data_rel)
x0		equ	rel+(_x0-data_rel)
y0		equ	rel+(_y0-data_rel)
julia_param	equ	rel+(_julia_param-data_rel)
zoom		equ	rel+(_zoom-data_rel)

; Ternary if-then-else
macro	ifel	cond, true, false
{
  if cond
	true
  else
	false
  end if
} ; ifel

; Define id as a pointer to 32-bit float n and store 32 or 16 bit (high word) of float depending on values of crunch_floats & allow_crunch
macro	float	id, n, allow_crunch = 1
{
  if	crunch_floats & allow_crunch
    local	float, hiword
    id	=	$-2
    virtual at 0
      float::	dd	n
    end virtual
    load hiword word from float:2
		dw	hiword
  else ; ~ crunch_floats...
    id		dd	n
  end if ; crunch_floats...
} ; float

;-- EXTRA MACROS -------------------------------------------------------------------------------------------------------

; Submacros for display macros
macro __digit num
{
  if num < 10
   display '0'+num
  else
   display 'A'+num-10
  end if
} ; __digit

; Submacros for display macros
macro __display arg1,arg2
{
  if arg2 eq
   display arg1
  else
   local ..tmp
   ..tmp = arg1
   virtual at 0
    repeat 32
     if ..tmp > 0
      db ..tmp mod arg2
      ..tmp = ..tmp / arg2
     end if
    end repeat
    repeat $
     load ..tmp byte from $-%
     __digit ..tmp
    end repeat
    if $ = 0
     display '0'
    end if
   end virtual
  end if
} ; __display

; Macros wrapper to display numbers
; Example: display 'Value = ',<count,10>
; (where 10 is radix)
; p.s. Thanks to Tomasz Grysztar for display macros wrapper
macro display [arg] { __display arg }

; Output 16-bit number in ax to es:di (must point to last digit position) by digit_color color
macro	OutputNumber
{
  bp_value	=	10
		mov	bp,bp_value
	.nextdigit:
		xor	dx,dx
		div	bp			; dx = digit
		push	ax

		; Output digit
		imul	si,dx,3
		add	si,digit_font
		mov	dx,320-5
		mov	cl,3			; number of bytes per digit
	.next1:
		lodsb
		mov	ah,al			; digit font bit mask
		mov	ch,8			; bit count
	.next2:
		salc
		shl	ah,1
		jnc	@F
		mov	al,digit_color
	@@:	stosb				; output digit
		dec	ch
		test	ch,3
		jnz	.next2
		salc
		stosb				; output black space
		add	di,dx
		test	ch,ch
		jnz	.next2
		loop	.next1

		sub	di,scr_width*6+5	; move pointer to previous char position
		
		pop	ax
		test	ax,ax
		jnz	.nextdigit
} ; OutputNumber

macro	DigitFont
{
  digit_font	db	01101001b,10011001b,10010110b	; 0
		db	00100110b,00100010b,00100111b	; 1
		db	01101001b,00010010b,01001111b	; 2
		db	11100001b,01100001b,00011110b	; 3
		db	00100110b,10101111b,00100010b	; 4
		db	11111000b,11100001b,00011110b	; 5
		db	01101000b,11101001b,10010110b	; 6
		db	11110001b,00100100b,01000100b	; 7
		db	01101001b,01101001b,10010110b	; 8
		db	01101001b,10010111b,00010110b	; 9
} ; DigitFont

;-----------------------------------------------------------------------------------------------------------------------
;-- CODE ---------------------------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------------------------------

format	binary as 'com'
org	0x100

		; Assume: ax = 0, (e)bx = 0, cx = 0xFF, dx = cs = ds = es = ss = psp, si = 0x100, bp = 0x9??, sp = 0xFFFE, word [sp] = 0, df = 0
		; Register ebx is globally used as music counter if dosbox_sound = 1

;-- INITIALIZATION -----------------------------------------------------------------------------------------------------

bp_value	=	-65536			; these two constants are used
di_value	=	0xFFFE			; for sound_counter access (-65536 means unknown)
		
		; Memory check
if	crunch_level < 1 & double_buffer
		mov	dx,cs
end if ; crunch_level < 1

if	check_memory
  if	double_buffer
		mov	di,[bx+2]		; paragraph behind this program
		sub	di,dx			; memory available
		cmp	di,memory_needed
		jae	@F
  else
		cmp	sp,di
		je	@F
  end if ; double_buffer
  if	check_memory = 2
		xchg	ax,bp			; ah = 9
		mov	dx,memory_msg
		int	0x21
  end if ; check_memory = 2
		ret				; exit if memory is not enough
	@@:
end if ; check_memory

		; Video init
		mov	al,0x13
		int	0x10

if	double_buffer
  ifel	crunch_level < 1, <add dh,0x10>, <add dh,al> ; al = 0x13
		mov	fs,dx			; buffer segment: PSP + 0x1000 (or 0x1300)
end if ; double_buffer

macro	SetupPalette
{
		; Setup palette
  ifel	flame_inside, <push bx>			; bx = 0, sp = -4 (preparation for flame palette setup)

  if	allow_col_blink
		mov	dx,0x3C9
    if	allow_col_blink = 2
		out	dx,al
		out	dx,al
		out	dx,al
    end if ; allow_col_blink = 2
  else ; ~ allow_col_blink
		mov	dx,0x3C8
		mov	al,1			; skip 0 color (black)
		out	dx,al
		inc	dx			; dx = 0x3C9
  end if ; allow_col_blink

		; Fractal palette (green-blue-violet)
  ifel	~ pal_corr, <dec cx>, <inc cx>		; cx = 0xFE or 0x100 = (0x7F + pal_corr) * 2
		mov	bl,pal_first_val
	.palette:
		xor	bl,-1			; not bx
		salc				; al = 0
		js	.pal0
		mov	al,bl
	.pal0:	out	dx,al			; red = (bl < 0) ? ~ bl : 0; green = (bl > 0) ? bl : 0
		xor	ah,dh
		jnz	@F			; skip next on the 1st pass, continue on the 2nd pass
		not	al
		out	dx,al			; blue = ~ green
  if	pal_start_green
		dec	bx
    ifel pal_chg_double, <dec bx>
  else ; ~ pal_start_green
		inc	bx
    ifel pal_chg_double, <inc bx>
  end if ; pal_start_green
	@@:	loop	.palette

  if	flame_inside
		; Flame palette (red-yellow-white)
		mov	bx,sp			; [bx] = -4 = bytes 0:0:0
	.flamepal:
		mov	cl,0x1F
	@@:	mov	si,sp
		outsb				; red
		outsb				; green
		outsb				; blue
		add	byte [bx],2
		loop	@B
		inc	bx
		jnz	.flamepal		; bx = 0 on exit
  end if ; flame_inside
} ; SetupPalette

		; Hardcoding to save only 1 byte of code :)
bx_is_set	=	0
use_freq_byte	=	0			; specify PIT counter divisor explicitly
if	approx_freq
  load first_byte byte from $$			; load first byte of code to first_byte
  if	~ (allow_exit & restore_int) & real_sys_sound & first_byte <> 0 & pit_freq/first_byte > sound_freq*4/5 & pit_freq/first_byte < sound_freq*5/4
    use_freq_byte	=	1		; use first byte of code as PIT counter divisor (sound frequency = sound_freq +/- 25%)
  else if	flame_inside & first_byte <> 0 & pit_freq/0x3E > sound_freq*4/5 & pit_freq/0x3E < sound_freq*5/4
    use_freq_byte	=	2		; use 0x3E as PIT counter divisor
  end if
end if ; approx_freq
		
if	use_freq_byte <> 1
	SetupPalette				; insert it here or below (if use_freq_byte = 1)
end if ; use_freq_byte <> 1

if	play_sound
		; Intercept interrupt
  if	allow_exit & restore_int
		mov	ax,0x3500 + int_no
		int	0x21			; get interrupt handler
    if	rel eq bx
		xchg	[_save_int_ofs],bx
		mov	[save_int_seg],es
      bx_is_set	=	1
    else ; ~ (rel eq bx)
		mov	[_save_int_ofs],bx
		mov	[_save_int_seg],es
      if	crunch_level = 0
		xor	ebx,ebx			; reset sound counter (good for restart)
      else if crunch_level = 1
		xor	bx,bx			; reset sound counter
      end if ; crunch_level
    end if ; rel eq bx
  end if ; allow_exit & restore_int

  ifel allow_exit & restore_int, <mov ah,0x25>, <mov ax,0x2500 + int_no>
		mov	dx,timer_int
		int	0x21			; set interrupt handler

		; Tune timer (PIT 8253/8254)
  ifel	use_int8, <mov al,0x14>			; set lower byte only (it need value 0x14 but 0x1C is proper too because bit 3 is not used)
		out	0x43,al
  ifel	use_freq_byte, lodsb, <mov al,pit_freq/sound_freq> ; PIT counter divisor
		out	0x40,al
end if ; play_sound

if	use_freq_byte = 1
	SetupPalette				; insert it here or above (this variant is forbidden when (allow_exit & restore_int) because bx (bh) <> 0 after ah = 0x35 DOS function or when dosbox_sound because bx will be changed by interrupt handle; see condition above)
end if ; use_freq_byte = 1

		; FPU initialization
ifel	fpu_init, fninit			;   st0   |   st1   |   st2   |   st3   |   st4   |   st5   |   st6   |   st7
ifel	fractal_type = 2, fld1, fldl2e		;  scale  (initial zoom: fld1 = 1, fldl2e = log2(e) = 1.442695040889, fldpi = pi = 3.14159265359, fldl2t = log2(10) = 3.321928094887)

ifel	rotate_image, fldz			;    a    |  scale  (fldpi - 180 dergee reversed)

;-- GRAB TO BMP INIT ------------------------------------------------------------------------------------------------------

if	grab2bmp
		pusha
		mov	ax,0xF001		; function 1 (init)
		mov	bp,'gb'
		xor	cx,cx			; first file number
		mov	dx,grab2bmp_max		; max file (frame) number
		mov	bx,bx			; no min number of digits in filename
		int	0x2F			; call grab2bmp
		popa
end if ; grab2bmp

;-- DRAW FRACTAL -------------------------------------------------------------------------------------------------------

if	rel eq bx & ~ bx_is_set
  ifel	data_align_256, <mov bh,data_rel / 256>, <mov rel,data_rel>
end if ; rel eq bx

mainloop:
ifel	double_buffer, <push fs>, <push 0xA000>
		pop	es

ifel	~ rel eq bx, <mov rel,data_rel>
		xor	di,di

		; Rotate
if	rotate_image
  ifel	crunch_floats < 2, <fadd dword [delta_a]>, \
			   <fadd qword [delta_a]>; +=delta |  scale
		fst	dword [angle]
		fsincos				;  cos a  | [sin_a] |  scale
end if ; rotate_image

		mov	dx,scr_height/size_div
	.loopY:
		mov	cx,-scr_width/size_div
	.loopX:
if	no_fractal <> 1
		mov	[temp],dx		; yc
		fild	word [temp]		;   st0   |   st1   |   st2   |   st3   |   st4   |   st5   |   st6   |   st7
ifel	rotate_image, <fmul st0,st3>, <fmul st0,st1> ; y  | [cos_a] | [sin_a] |  scale
ifel	~ rotate_image & ~ (fractal_type <> 0 & center_julia), <fadd dword [y0]>

		mov	[temp],cx		; xc
		fild	word [temp]
ifel	rotate_image, <fmul st0,st4>, <fmul st0,st2> ; x  |    y    | [cos_a] | [sin_a] |  scale
ifel	~ rotate_image & ~ (fractal_type <> 0 & center_julia), <fadd dword [x0]>

if	rotate_image
		; Rotate: x' = x*cos_a - y*sin_a + x0, y' = x*sin_a + y*cos_a + y0
		fld	st1			;    y    |    x    |    y    |  cos_a  |  sin_a  |  scale
		fmul	st0,st3			; y*cos_a |    x    |    y    |  cos_a  |  sin_a  |  scale
		fld	st1			;    x    | y*cos_a |    x    |    y    |  cos_a  |  sin_a  |  scale
		fmul	st0,st5			; y*sin_a | y*cos_a |    x    |    y    |  cos_a  |  sin_a  |  scale
		faddp				;x*sa+y*ca|    x    |    y    |  cos_a  |  sin_a  |  scale
ifel	~ (fractal_type <> 0 & center_julia), <fadd dword [y0]> ; y'| x  | y  |  cos_a  |  sin_a  |  scale

		fxch	st2			;    y    |    x    |    y'   |  cos_a  |  sin_a  |  scale
		fmul	st0,st4			; y*sin_a |    x    |    y'   |  cos_a  |  sin_a  |  scale
		fxch				;    x    | y*sin_a |    y'   |  cos_a  |  sin_a  |  scale
		fmul	st0,st3			; x*cos_a | y*sin_a |    y'   |  cos_a  |  sin_a  |  scale
		fsubp				;x*cs-y*sn|    y'   |  cos_a  |  sin_a  |  scale
ifel	~ (fractal_type <> 0 & center_julia), <fadd dword [x0]> ; x'| y'|cos_a|  sin_a  |  scale
end if ; rotate_image

		; Calculate fractal
if	fractal_type = 0
		fld	st1
		fld	st1			;    x    |    y    |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale
end if ; fractal_type = 0
if	crunch_level > 0 & ~ flame_inside & ~ (interleave & il_duplicate) & ~ allow_exit & ~ frame_counter
  mov al,max_frac_color+1
else ; ~ (crunch_level > 0...)
  ifel	flame_inside & ~ no_fractal, <mov ax,max_frac_color>, <mov ax,max_frac_color+1>
end if ; crunch_level > 0...
	.nextiter:
		; x. = x^2 - y^2 + x, y. = 2 * x * y + y
		fld	st1			;    y    |    x    |    y    |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale
		fadd	st2,st0			;    y    |    x    |   2*y   |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale
		fmul	st0,st0			;   y^2   |    x    |   2*y   |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale
		fxch				;    x    |   y^2   |   2*y   |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale
		fmul	st2,st0			;    x    |   y^2   |  2*x*y  |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale
		fmul	st0,st0			;   x^2   |   y^2   |  2*x*y  |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale

		fadd	st0,st1			; x^2+y^2 |   y^2   |  2*x*y  |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale
		fist	word [temp]		; temp = x^2 + y^2 (distance^2)
		fsub	st0,st1			; restore st0 = x^2

		fsubrp				; x^2-y^2 |  2*x*y  |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale
if	fractal_type = 0 ; Mandelbrot
		fadd	st0,st2			;    x.   |  2*x*y  |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale
		fld	st3			;    y    |    x.   |  2*x*y  |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale
		faddp	st2,st0			;    x.   |    y.   |   [x']  |   [y']  | [cos_a] | [sin_a] |  scale
else if	fractal_type = 1 ; static Julia
		fld	dword [julia_param]	;  j_par  | x^2-y^2 |  2*x*y  | [cos_a] | [sin_a] |  scale
		fadd	st2,st0			;  j_par  | x^2-y^2 |    y.   | [cos_a] | [sin_a] |  scale
		faddp				;    x.   |    y.   | [cos_a] | [sin_a] |  scale
else if fractal_type = 2 ; dynamic Julia
 		fld	dword [julia_param]	;  j_par  | x^2-y^2 |  2*x*y  | [cos_a] | [sin_a] |  scale
  if	rotate_image
    ifel julia2_sub, <fsub st0,st5>, <fadd st0,st5> ;j_par+scl|x^2-y^2| 2*x*y | [cos_a] | [sin_a] |  scale
  else	; ~ rotate_image
    ifel julia2_sub, <fsub st0,st3>, <fadd st0,st3> ;j_par+scl|x^2-y^2| 2*x*y | scale
  end if ; rotate_image
 		fadd	st2,st0			;j_par+scl| x^2-y^2 |    y.   | [cos_a] | [sin_a] |  scale
 		faddp				;    x.   |    y.   | [cos_a] | [sin_a] |  scale
else
  display 13,10
  display '------------------------------------',7,13,10
  display 'ERROR : Wrong fractal_type value !!!',7,13,10
  display '------------------------------------',7,13,10
  err
end if ; fractal_type
		cmp	word [temp],4		; compare distance^2 with 4 (bailout)
if	flame_inside & ~ no_fractal
		ja	.out			; jump if distance^2 > 4
		dec	ax
		jnz	.nextiter		; jump if ax != 0
else ; ~ flame_inside
		cmc				; invert comparison result (as if we did cmp 4,word [temp])
		dec	ax			; set zf, cf is unchanged
		ja	.nextiter		; jump if ax != 0 & distance^2 <= 4
end if ; flame_inside
end if ; no_fractal <> 1

		; Draw pixel
if	flame_inside
  ifel	no_fractal, <xor ax,ax>
		inc	ax
  if	interleave
		mov	il_temp_reg,di
		shr	il_temp_reg,interleave
		or	al,[il_temp_reg+flame_buf]
  else ; ~ interleave
		or	al,[di+flame_buf]
  end if ; interleave
		ror	al,1			; al = [di+flame_buf] / 2 | 0x80
	.out:
end if ; flame_inside

if	no_fractal <> 1
ifel	fractal_type = 0, fcompp		;   [x']  |   [y']  | [cos_a] | [sin_a] |  scale  (remove 2 numbers from fpu stack)
		fcompp				; [cos_a] | [sin_a] |  scale                      (remove 2 numbers from fpu stack)
end if ; no_fractal <> 1

if	interleave = 0
		stosb				; put pixel
else ; interleave <> 0
  if	il_duplicate
		mov	ah,al
    if	interleave = 2
      bp_value	=	scr_width
		mov	bp,bp_value
		mov	[es:di+bp],ax
    end if ; interleave = 2
  end if ; il_duplicate
		stosw				; put pixels
  ifel	interleave = 1, <inc cx>
end if ; interleave
		inc	cx			; x++
ifel	scr_width/size_div < 128, <cmp cl,scr_width/size_div>, <cmp cx,scr_width/size_div>
		jne	.loopX

if	interleave = 2
  ifel il_duplicate, <add di,bp>, <add di,scr_width>
end if ; interleave = 2

		dec	dx			; y--
		cmp	dl,-scr_height/size_div
		jne	.loopY

		; Zoom
ifel	rotate_image, fcompp			;  scale  (remove 2 numbers from fpu stack)
		fmul	dword [zoom]		; *=zoom

ifel	rotate_image, <fld dword [angle]>	;    a    |  scale  (for next iteration on mainloop)

di_value	=	scr_width*scr_height

;-- DRAW FLAME ---------------------------------------------------------------------------------------------------------

if	flame_inside
  ifel	frame_counter, <push es>

		push	ds
		pop	es
		mov	di,_flame_buf

		; Burn
		mov	cx,scr_width*(scr_height-flame_cut_lines) / (width_div*height_div)
  bp_value	=	scr_width/width_div - 1
		mov	bp,bp_value
		lea	si,[di+bp]
	.pixel:	lodsb
		add	al,[si]
		setc	ah
		add	al,[si+bp]
  ifel real_sys_compat & data_align_256, <adc ah,bl>, <adc ah,0>
  ifel interleave <> 2, <imul ax,0x56-flame_with_smog>, <imul ax,0x55-flame_with_smog> ; fast division by ~3
		shr	ax,8			; wind: ([X-1, Y+1] + [X, Y+1] + [X-1, Y+2]) / 3, no wind: ([X-1, Y+1] + [X+1, Y+1] + [X, Y+2]) / 3
  if	~ flame_with_smog
		jz	@F
		dec	ax			; pixel-- (smog suppression)
  end if ; ~ flame_with_smog
	@@:	stosb
		loop	.pixel

		; Random bottom
  ifel crunch_level < 1 | (frame_counter & ~ interleave), <mov cx,scr_width*2>, <mov ch,(scr_width*2+255) / 256>
		rdtsc
	@@:
  if	~ simple_rand_gen
		xadd	dx,ax
		rol	dx,1
		salc				; 0 or 0xFF
		and	al,0xF7

  else ; simple_rand_gen
		xadd	ax,bp
  end if ; ~ simple_rand_gen
		stosb
		loop	@B
  di_value	=	buffers_end
end if ; flame_inside

;-- DEBUG SECTION ------------------------------------------------------------------------------------------------------

		; Frame counter
if	frame_counter
  ifel	flame_inside, <pop es>
		inc	[frame_count]
		mov	ax,[frame_count]
		mov	di,scr_width*(scr_height-7)-7 ; position of last digit
  di_value	=	-65536			; unknown
		OutputNumber
end if ; frame_counter

;-- COPY AND DELAY, SYNC -----------------------------------------------------------------------------------------------

		; Copy to screen (if double_buffer)
if	double_buffer
  ifel	interleave & ~ il_duplicate, <xor dx,dx>
		xor	si,si
		push	0xA000
		pop	es
		xor	di,di
  ifel	flame_inside, <mov ch,scr_width*scr_height/2/256>, <mov cx,scr_width*scr_height / 2>
  if	interleave & ~ il_duplicate
	@@:	fs lodsw
		stosw				; copy from screen buffer to screen
		mov	[fs:si-2],dx		; clear buffer
		loop	@B
  else ; ~ (interleave and ~ il_duplicate)
		rep fs movsw			; copy from screen buffer to screen
  end if ; interleave and ~ il_duplicate
  di_value	=	320*200
end if ; double_buffer

		; Delay
if	delay_method and 1
  if	play_sound
    if	dosbox_sound
	@@:
      if timer_delay_mask < 0xFF
		test	bl,timer_delay_mask
      else if timer_delay_mask = 0xFF
		test	bl,bl
      else ; timer_delay_mask > 0xFF
		test	bx,timer_delay_mask
      end if ; timer_delay_mask
		jnz	@B

    else ; ~ dosbox_sound
      bx_value = data_rel
      bx_di_value = -65536
      bp_di_value = -65536
      if di_value <> -65536
        bx_di_value = (bx_value + di_value) mod 65536
        ifel bp_value <> -65536, <bp_di_value = (bp_value + di_value) mod 65536>
      end if ; di_value <> -65536
;display 13,10
;display 'bx=',<bx_value,10>, ', bp=',<bp_value,10>, ', di=',<di_value,10>, ', si=',<_flame_bottom+bp_value,10>, 13,10
;display 'bx_di_value=',<bx_di_value,10>, ', bp_di_value=',<bp_di_value,10>, 13,10
	@@:
      if sound_counter-bx_di_value >= -128 & sound_counter-bx_di_value <= 127 ; one byte crunch :)
        ifel timer_delay_mask <= 0xFF, <test byte [bx+di+sound_counter-bx_di_value],timer_delay_mask>, \
				       <test word [bx+di+sound_counter-bx_di_value],timer_delay_mask>
      else if sound_counter-bp_di_value >= -128 & sound_counter-bp_di_value <= 127
        ifel timer_delay_mask <= 0xFF, <test byte [bp+di+sound_counter-bp_di_value],timer_delay_mask>, \
				       <test word [bp+di+sound_counter-bp_di_value],timer_delay_mask>
      else if sound_counter-bp_value >= -128 & sound_counter-bp_value <= 127 & sound_counter-bp_value <> 0
        ifel timer_delay_mask <= 0xFF, <test byte [bp+sound_counter-bp_value],timer_delay_mask>, \
				       <test word [bp+sound_counter-bp_value],timer_delay_mask>
      else ; sound_counter-...
        ifel timer_delay_mask <= 0xFF, <test byte [sound_counter],timer_delay_mask>, \
				       <test word [sound_counter],timer_delay_mask>
      end if ; flame_inside
		jnz	@B
    end if ; dosbox_sound
  else ; ~ play_sound
		hlt
  end if ; play_sound
end if ; delay_method

		; V-Sync
if	delay_method and 2
		mov	dx,0x3DA
	@@:	in	al,dx
		test	al,8			; vertical retrace
		jz	@B
end if ; delay_method

;-- GRAB TO BMP --------------------------------------------------------------------------------------------------------

if	grab2bmp
		mov	ax,0xF003		; function 3 (grab to bmp)
		mov	bp,'gb'
		int	0x2F			; call grab2bmp
		cbw
		test	al,al
  if	allow_exit
		jnz	.exit
  else
		jz	@F
    ifel flame_inside, <int 0x20>, ret
	@@:
  end if ; allow_exit
end if ; grab2bmp

;-- LOOP OR EXIT -------------------------------------------------------------------------------------------------------

		; Key check and loop
if	~ allow_exit
		jmp	mainloop

else ; allow_exit
  if	any_key_exit
		mov	ah,1
		int	0x16
		jz	mainloop		; exit by any key press
  else ; ~ any_key_exit
		in	al,0x60
		cbw
		dec	ax
		jnz	mainloop		; exit by Esc key
  end if ; any_key_exit
	.exit:
		; Set text mode
  if	exit_text_mode
    ifel any_key_exit, <mov ax,3>, <mov al,3>
		int	0x10
  end if ; exit_text_mode

		; Show credits
  if	show_credits and 0x7F
		mov	ah,9
		mov	dx,credits
		int	0x21
  end if ; show_credits and 0x7F

  if	play_sound
    if	restore_int
		; Restore interrupt handler
		mov	ax,0x2500 + int_no
      ifel real_sys_compat, <lds dx,dword [save_int_ofs]>, <lds dx,dword [_save_int_ofs]>
		int	0x21
    end if ; restore_int

    if	restore_timer
		; Restore timer
		mov	al,0x24
		out	0x43,al
		xor	al,al			; salc? (not safely)
		out	0x40,al
    end if ; ~ restore_timer
  end if ; play_sound

		; Clear keyboard buffer and pause
  if	clear_key_buf
    ifel ~ any_key_exit | exit_text_mode | (play_sound & (restore_int | restore_timer)), <mov ah,0x0C>, <mov ax,0xC00>
		int	0x21
  end if ; clear_key_buf

  if	show_credits and 0x7F & show_credits and 0x80
    ifel ~ any_key_exit | exit_text_mode | (play_sound & (restore_int | restore_timer)) | clear_key_buf, cbw, <xor ah,ah>
		int	0x16			; pause
  end if ; show_credits...

		; Exit
  ifel	flame_inside, <int 0x20>, ret
end if ; ~ allow_exit

;-- SOUND --------------------------------------------------------------------------------------------------------------

		; Play sound
if	play_sound
timer_int:
  if	dosbox_sound & sound_device = 0
		push	ax
  else ; ~ (dosbox_sound & sound_device = 0)
    ifel crunch_level < 2, pushad, pusha
  end if ; dosbox_sound & sound_device = 0

  if	real_sys_sound
		mov	bx,sound_counter
    if	sound_cnt32
		inc	dword [cs:bx]
		mov	ebx,[cs:bx]
    else ; ~ sound_cnt32
		inc	word [cs:bx]
		mov	bx,[cs:bx]
    end if ; sound_cnt32
  end if ; real_sys_sound
  if	song_number = 1
		; min(1, t & t>>11) * volume
		shld	eax,ebx,32-11
		and	ax,bx
  else ; song_number = 2
		; min(1, t & t>>8) * volume
		test	bl,bh
		salc
  end if ; song_number
		jz	.play
  if	sound_device = 0 ; pc speaker
  		mov	al,2
	.play:
		out	0x61,al			; play
  else if sound_device = 1 ; covox
		mov	al,sound_volume
	.play:
		mov	dx,0x378
		out	dx,al			; play
  end if ; sound_device

  if	use_int8
		mov	al,0x20
		out	0x20,al			; send EOI
  end if ; use_int8
  
  if	dosbox_sound & sound_device = 0
		pop	ax
  else ; ~ (dosbox_sound & sound_device = 0)
    ifel crunch_level < 2, popad, popa
  end if ; dosbox_sound & sound_device = 0

  ifel	dosbox_sound, <inc ebx>

		iret
end if ; play_sound

;-----------------------------------------------------------------------------------------------------------------------
;-- DATA ---------------------------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------------------------------

		; Float numbers
float		_zoom,	0.99			; zoom factor (~ 0.99 is ok)

if	fractal_type < 2
  if	fractal01_param = 0
    float	_x0, 0.386843770742416, 0	; x0 of center
  else if fractal01_param = 1
    float	_x0, -0.5558			; [2 bytes less if crunch_floats <> 0]
  end if ; fractal01_param
else if	fractal_type = 2
  if	fractal2_param = 0
    float	_x0, -0.55354, 0		; julia2_sub = 1 (for fractal2_param < 3, see above)
  else if fractal2_param = 1
    float	_x0, -0.5536735, 0		; julia2_sub = 1
  else if fractal2_param = 2
    float	_x0, -0.5558			; julia2_sub = 1 [2 bytes less if crunch_floats <> 0]
  else if fractal2_param = 3
    float	_x0, 0.35123, 0			; julia2_sub = 0 (for fractal2_param >= 3, see above)
  else if fractal2_param = 4
    float	_x0, 0.351, 0			; julia2_sub = 0
  else if fractal2_param = 5
    float	_x0, 0.350			; julia2_sub = 0 [2 bytes less if crunch_floats <> 0]
  end if ; fractal2_param
end if ; fractal_type
_y0		=	_x0			; y0 of center
_julia_param	=	_x0			; Julia fractal parameter

if	rotate_image & crunch_floats < 2
  float		_delta_a, 0.008726646259972	; rotation angle increment (0.5 degrees ~ 0.0087266 is ok)
else ; ...crunch_level >= 1
  _delta_a	=	_zoom-4
end if ; rotate_image...

if	allow_exit & show_credits and 0x7F
  credits:
  if	show_credits and 0x7F = 2
  		db	'DEEP TRIP',13,10
  end if ; show_credits and 0x7F = 2
		db	'(c) 2019 by Jin X'
  if	show_credits and 0x7F = 2
		db	13,10
		db	'Coded for CAFePARTY 2019',13,10
  end if ; show_credits and 0x7F = 2
		db	'$'
end if ; show_credits and 0x7F

if	check_memory = 2
  memory_msg	db	'No memory!$'
end if ; check_memory = 2

if	frame_counter
  DigitFont
  frame_count	dw	0
end if ; frame_counter

if	real_sys_sound & allow_exit & restore_int
  _save_int_ofs	dw	data_rel
  _save_int_seg	rw	1
end if ; real_sys_sound & allow_exit & restore_int

code_end:
ifel	data_align_256, <align 256>, <align 4>
data_rel:

display	13,10,'Difference between data_rel and code_end: ', <data_rel - code_end, 10>, ' bytes.',13,10
if	data_align_256 & data_rel - code_end > 64
  display '----------------------------------------------------------------------------'
  if	data_rel - _zoom > 128 | (rotate_image & crunch_level >= 1 & data_rel - _delta_a > 128)
    display '-',7,13,10,'WARNING : Difference between data_rel and code_end is more than 128 bytes !!!',7,13,10
    display 'Code is not optimized! Try to set data_align_256 = 0 to optimize it.',7,13,10,'-'
  else ; <= 128
    display 13,10,'WARNING : Difference between data_rel and code_end is more than 64 bytes !!!',13,10
  end if ; > 128
  display '----------------------------------------------------------------------------',7,13,10,13,10
end if ; data_align_256...

;-- BUFFERS ------------------------------------------------------------------------------------------------------------

		rb	0x10			; reserve for temp data

if	flame_inside
  _flame_buf	rb	scr_width*(scr_height-flame_cut_lines) / (width_div*height_div)

  if	crunch_level < 1 | (frame_counter & ~ interleave)
    _flame_bottom rb	scr_width*2
  else ; crunch_level = 0
    _flame_bottom rb	(scr_width*2+255) / 256 * 256
  end if ; crunch_level < 1 ...
end if ; flame_inside

buffers_end:

;-- STACK CHECK --------------------------------------------------------------------------------------------------------

stack_buffer	=	(65534-flame_inside*2 - $)
display	'Memory reserved for stack (after all data): ', <stack_buffer, 10>, ' bytes.',13,10
if	stack_buffer < 16
  display '-------------------------------------------------',7,13,10
  display 'ERROR : Not enough memory for flame and stack !!!',7,13,10
  display 'Increase flame_cut_lines / set data_align_256 = 0',7,13,10
  display '-------------------------------------------------',7,13,10
  err
else if	stack_buffer < 128
  display '-----------------------------------------------------',13,10
  display 'WARNING : Memory for stack is less than 128 bytes !!!',13,10
  display 'Increase flame_cut_lines / set data_align_256 = 0.',13,10
  display '-----------------------------------------------------',7,13,10
end if
display 13,10
