                processor 6502 
                include "vcs.h" 
                include "macro.h" 

;/////////////////  Start of Code ///////////////////////////////////// 

                SEG 
                ORG $F000 

Reset 
    		; Clear RAM, TIA registers and Set Stack Pointer to #$FF
		SEI
		CLD	
;		LDX #$FF
;		TXS
;		LDA #0
;		sta $B0
;Clear_Mem
;		STA 0,X
;		DEX
;		BNE Clear_Mem			
		
;;                LDA #$00
;;                STA COLUBK	; Set Background to Black
;;                LDA #15*7
;;                STA COLUPF
;;                LDA #0%00000001  ; Mirrored Playfield
;;                STA CTRLPF

Start_Frame 

    	; Start VSYNC

                LDA #2 
                STA VSYNC 

                STA WSYNC 
                STA WSYNC 
                STA WSYNC    	; 3 Scanlines of VSYNC 

                LDY #0
                STY VSYNC	; End VSYNC         


	; 37 Scanlines of Vertical Blank... 
;           
;       		LDX #37
;Vertical_Blank  STA WSYNC 
;                DEX 
;                BNE Vertical_Blank 

  	;>>>>>>>>>>>>> Start of Vertival Blank <<<<<<<<<<<<<<<<<<<
  	; Count 37 Scanlines

	LDA  #43	;			// 2 cycles
	STA  TIM64T	;			// 4 cycles
	
	;>>>>>>>>>>>>>>>> Free space for code starts here 


	;>>>>>>>>>>>>>>>> Free space for code ends here

Wait_VBLANK_End
	LDA INTIM	;			// 4 cycles
	BPL Wait_VBLANK_End	;		// 3 cycles

	STA WSYNC	;       		// 3 cycles  Total Amount = 21 cycles
			;			2812-21 = 2791; 2791/64 = 43.60

	inc $B0
	lda $B0
;	ldy #0
	STY VBLANK 	; Enable TIA Output
	ldx #192
	STA WSYNC
tlp:
	tya
	eor $B0
	sta COLUBK
	iny
	dex
	stx WSYNC
	bne tlp
;////////////// End Of Display ////////////////////////////////////////      	
    
		LDA #%01000010 		; Disable VIA Output
                STA VBLANK           

	; 30 scanlines of overscan... 

                LDX #30 
Overscan        STA WSYNC 
                DEX 
                BNE Overscan 

		JMP Start_Frame 	; Build Next Frame

pat include "pats.h"
;////////////// Set Vectors ///////////////////////////////////////////

            ORG $FFFA 

; Interrupt Vectors 

            .word Reset           ; NMI 
            .word Reset           ; RESET 
            .word Reset           ; IRQ 

          END 

