#version 450
layout(set = 0, binding = 0) uniform _Time { float Time; };
layout(set = 0, binding = 1) uniform _Offset { vec2 Offset; };
layout(set = 0, binding = 2) uniform _Zoom { float Zoom; };
layout(location = 0) in vec2 fsin_Position;
layout(location = 0) out vec4 fsout_Color;
float beat = 0.9375;
float beats = (Time / beat);
vec2 pR(vec2 p, float a)
{
p = ((p * cos(a)) + (vec2(p.y, (-p.x)) * sin(a)));
return p;

}

float rand1d(float n)
{
return fract((sin(n) * 43758.55));

}

float noise(vec2 uv, float intensity)
{
return min(1.0, ((1.0 / (rand1d(((uv.x * 20.0) + 1.0)) + rand1d((uv.y * 40.0)))) * intensity));

}

float spikeFunc(float x)
{
return max(min(min(fract(x / -2.) * 2. -1., sin((x + 1.) / 0.31831 ) + 1.), sin((x - 1.278) / 0.31831) + 0.645), 0.);

}

float superclamp(float val, float start, float end)
{
float dur = (end - start);
float halfdur = (dur / 2.0);
float prog = (clamp(val, start, end) - start);
return ((halfdur - abs((prog - halfdur))) / halfdur);

}

void main()
{
float audio1 = max(0.0, (0.1 - fract(((beats * 4.0) + 0.04))));
float audio2 = max(0.0, (0.1 - fract((((beats * 4.0) + 0.05) - 0.4))));
float audio3 = (step(1.5, (fract((beats / 2.0)) * 2.0)) - step(8.0, (fract((beats / 2.0)) * 2.0)));
vec2 uv = fsin_Position;
uv = vec2((uv.x + (audio1 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio2 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio3 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = ((uv / 2.0) - Offset);
uv = (uv * (1.0 + (Zoom * Zoom)));
vec3 c = vec3(0.0);
vec3 r = vec3(0.68, 0.18, 0.14);
vec3 g = vec3(0.87, 0.89, 0.78);
vec3 b = vec3(0.0, 0.6, 0.96);
float l = clamp((max((tan(pR(vec2(max(pR(vec2((smoothstep(pR(vec2((floor((pR((uv * 5.0), (pR((uv * 5.0), pR(vec2((uv.x * 10.0), sin(sin((pR(vec2(pR(vec2((floor((((floor(((sin(pR(vec2((uv.x * 10.0), pR((uv * 1.5), (pR(vec2((uv.y * 10.0), smoothstep(pR(vec2((uv.y * 10.0), (pR(vec2((uv.y * 10.0), (tan(pR((uv * 5.0), (floor((cos((floor((cos(pR(vec2(length(vec2(((pR((uv * 1.5), (round((pR(vec2((max(((floor((smoothstep(pR((uv * 1.5), (smoothstep((-(((floor((pR((uv * 5.0), pR(vec2(length(vec2(pR((uv * 1.5), pR(vec2((uv.y * 10.0), pR(vec2(max(pR((uv * 5.0), (length(vec2(length(vec2(pR(vec2((uv.x * 10.0), pR(vec2(sin(length(vec2(pR((uv * 5.0), (pR(vec2(pR((uv * 5.0), (floor((sin(cos((-(tan((floor((pR(vec2((uv.x * 10.0), length(vec2(pR((uv * 1.5), max((floor((pR(vec2((uv.y * 10.0), (-pR((uv * 5.0), length(vec2(pR(vec2((tan(pR((uv * 5.0), pR((uv * 5.0), length(vec2(sin(pR(vec2((pR((uv * 5.0), pR((uv * 5.0), (floor((pR(vec2((uv.y * 10.0), cos((-cos(cos(sin(pR(vec2(pR(vec2((uv.y * 10.0), (floor((max(((floor((smoothstep(pR(vec2((-pR(vec2(pR(vec2((uv.y * 10.0), (round((cos(pR((uv * 5.0), pR(vec2((tan(length(vec2((tan(sin(pR(vec2(pR((uv * 1.5), pR((uv * 5.0), pR(vec2((uv.y * 10.0), pR((uv * 5.0), sin(pR((uv * 1.5), pR(vec2(pR(vec2((uv.x * 10.0), (max(sin((-length(vec2(sin((tan(max(sin((-pR(vec2((uv.x * 10.0), (sin(length(vec2((cos(pR(vec2(length(vec2(pR(vec2((-(-(floor((pR(vec2(pR(vec2((((-smoothstep(pR((uv * 1.5), max(pR((uv * 1.5), (floor((cos(pR(vec2(pR(vec2(pR(vec2((uv.y * 10.0), pR(vec2((-pR((uv * 5.0), pR((uv * 5.0), (pR(vec2(length(vec2(((cos((round((((((-(floor((pR(vec2((uv.y * 10.0), (round((pR(vec2((uv.x * 10.0), pR(vec2((uv.x * 10.0), sin((-(smoothstep((round((pR((uv * 5.0), smoothstep(pR((uv * 5.0), (tan((cos(pR((uv * 1.5), ((floor((length(vec2(pR(vec2((uv.y * 10.0), pR(vec2((uv.y * 10.0), max(length(vec2(smoothstep((floor((pR(vec2((uv.y * 10.0), cos(max(max(smoothstep((pR(vec2((uv.y * 10.0), length(vec2(pR(vec2(cos(pR(vec2((-pR(vec2((uv.y * 10.0), cos(pR(vec2((uv.y * 10.0), (floor((pR((uv * 5.0), (round((cos(pR(vec2(max(pR(vec2(length(vec2(pR(vec2(pR(vec2(pR((uv * 5.0), smoothstep(pR((uv * 5.0), pR(vec2((uv.y * 10.0), (round(((pR((uv * 5.0), pR((uv * 5.0), pR((uv * 1.5), ((round((pR(vec2(pR((uv * 5.0), (((floor(((pR((uv * 1.5), max(pR((uv * 1.5), (pR(vec2(length(vec2((pR(vec2((pR((uv * 5.0), pR(vec2(((round((smoothstep((round(((pR(vec2((uv.x * 10.0), pR(vec2((uv.y * 10.0), (pR(vec2((uv.x * 10.0), pR((uv * 1.5), max(pR(vec2((uv.y * 10.0), pR((uv * 1.5), pR(vec2((uv.y * 10.0), pR((uv * 5.0), (-pR(vec2((uv.y * 10.0), (floor(((-pR((uv * 1.5), smoothstep(pR(vec2((floor((length(vec2((tan(pR(vec2(pR((uv * 5.0), pR(vec2((-pR((uv * 5.0), ((pR(vec2((tan(max((round((pR(vec2((uv.x * 10.0), (-sin(cos(max((round((((-((floor((cos((-pR((uv * 1.5), length(vec2(((pR(vec2((uv.x * 10.0), pR((uv * 5.0), pR((uv * 5.0), (max(smoothstep((round((max(pR(vec2((uv.x * 10.0), sin((round((cos(max(pR(vec2((uv.x * 10.0), pR((uv * 1.5), pR(vec2((uv.y * 10.0), pR(vec2((uv.y * 10.0), ((pR(vec2((uv.x * 10.0), pR(vec2(pR((uv * 5.0), pR((uv * 1.5), cos((floor((((round((max(pR((uv * 1.5), pR(vec2(pR(vec2(cos(length(vec2(pR((uv * 1.5), cos(max(pR(vec2((uv.x * 10.0), pR((uv * 1.5), (pR((uv * 5.0), ((-(floor((sin(sin(pR((uv * 5.0), (pR(vec2(max(((pR(vec2((uv.x * 10.0), max(smoothstep(cos(pR(vec2(pR((uv * 1.5), (round(((floor((max(pR((uv * 1.5), ((tan(pR((uv * 5.0), pR(vec2((uv.x * 10.0), pR(vec2(cos((round(((length(vec2(length(vec2((tan((tan((-smoothstep(((-pR(vec2((uv.y * 10.0), (tan(pR(vec2(length(vec2(pR((uv * 5.0), (round((pR(vec2((uv.y * 10.0), pR((uv * 5.0), (cos(length(vec2(pR(vec2(max(cos(pR((uv * 5.0), cos(sin(pR(vec2((length(vec2(pR((uv * 1.5), pR((uv * 1.5), (sin(pR(vec2((uv.y * 10.0), max(smoothstep(max(max(pR(vec2(length(vec2((sin(pR((uv * 1.5), sin((round((max(max(pR((uv * 1.5), pR((uv * 1.5), max(pR(vec2((round(((pR(vec2(pR((uv * 5.0), smoothstep(pR((uv * 1.5), pR((uv * 5.0), pR(vec2((uv.y * 10.0), pR(vec2(max(pR((uv * 5.0), length(vec2(max(pR((uv * 5.0), pR((uv * 1.5), (pR(vec2((uv.x * 10.0), length(vec2(pR(vec2(sin((length(vec2((-max(pR(vec2((uv.y * 10.0), smoothstep(smoothstep(max((round((cos(pR((uv * 1.5), (-pR(vec2((uv.x * 10.0), (-pR((uv * 5.0), (round((smoothstep(max(pR((uv * 5.0), 3.1416).x, audio3), 0.0, 0.1) * 7.0)) / 7.0)).x)), audio3).x)).x) * 7.0)) / 7.0), (sin(((beats * 1.57) * 0.5)) * 4.0)), 0.0, 0.1), 0.0, 0.1)), (length(uv) * 10.0)).y, audio1)), (uv.y * 8.0))) + (uv.x * 10.0))), audio2), (beats * 0.25)).x, audio1))), (length(uv) * 10.0)).x / (1.3 / audio2))).x).y, (tan(((beats * 3.14) * 0.5)) / 2.0)), (uv.y * 1.5)))).x, audio3), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y), (length(uv) * 10.0)).y).y).x, 0.0, 0.1)).y, (uv.y * 1.5)), (beats * 0.25)).y / (1.3 / (uv.y * 8.0))) * 7.0)) / 7.0), (uv.x * 10.0)), (beats * 0.25)).x, (sin(((beats * 1.57) * 0.5)) * 4.0))).y).x, audio1), audio2) * 7.0)) / 7.0))).y) + (uv.y * 8.0)), 4.0)), (uv.y * 1.5)), (beats * 0.25)).x, (tan(((beats * 3.14) * 0.5)) / 2.0)), (length(uv) * 10.0)), 0.0, 0.1), (length(uv) * 10.0))), 3.1416).y) - (uv.x * 2.0))).x).y, (sin(((beats * 1.57) * 0.5)) * 4.0))) + sin(((beats * 1.57) * 0.25))), audio2), (beats * 0.25)).y))).x), 4.0), audio2), (beats * 0.25)).x, sin(((beats * 1.57) * 0.25))))) - (uv.y * 1.5))).x), 3.1416).y * 7.0)) / 7.0)).x, (sin(((beats * 1.57) * 0.5)) * 4.0))), (length(uv) * 10.0)), (beats * 0.25)).y) / 2.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)).y) - audio3), 0.0, 0.1))) / 2.0)) / 2.0), sin(((beats * 1.57) * 0.25)))), 4.0)) / (1.3 / sin(((beats * 1.57) * 0.25)))) * 7.0)) / 7.0)), audio1), (beats * 0.25)).y), (uv.x * 2.0)).x).y) / 2.0) + (uv.y * 8.0))).y, (uv.x * 2.0)) * 7.0)) / 7.0) * 7.0)) / 7.0)).x, sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y), 0.0, 0.1), sin(((beats * 1.57) * 0.25)))), 3.1416).x / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0))) - (uv.x * 2.0)), audio2), 3.1416), (beats * 0.25)).y - (sin(((beats * 1.57) * 0.5)) * 4.0))).x)) * 7.0)) / 7.0)) / (1.3 / (uv.y * 8.0)))).y - 4.0)).x), 3.1416).x, (uv.y * 1.5)))).x, (uv.y * 1.5)))), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).x, sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y).y, 4.0) * 7.0)) / 7.0) + (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0))).y).x, (length(uv) * 10.0)), (beats * 0.25)).x), (uv.x * 2.0)).x + 3.1416) + audio1)), (uv.y * 1.5)).y), (uv.x * 10.0)).y).y), (uv.x * 10.0)).x, (tan(((beats * 3.14) * 0.5)) / 2.0))) * 7.0)) / 7.0))), (uv.y * 8.0)).x, (uv.x * 10.0)) * 7.0)) / 7.0), 0.0, 0.1), audio2) + sin(((beats * 1.57) * 0.25)))).x).x), audio2).x / (1.3 / audio2)) / (1.3 / 3.1416)), (length(uv) * 10.0)))).x)) * 7.0)) / 7.0) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0)))) / (1.3 / (length(uv) * 10.0))) * 7.0)) / 7.0), audio2))))), audio2).x * 7.0)) / 7.0), (uv.y * 8.0))) / 2.0), (length(uv) * 10.0)), (beats * 0.25)).y / (1.3 / 3.1416)) / (1.3 / (uv.x * 2.0)))).x), audio2), (beats * 0.25)).x).x, 3.1416), (beats * 0.25)).y) / 2.0), audio1)) * 7.0)) / 7.0), (uv.x * 10.0)), (beats * 0.25)).x, 0.0, 0.1)).x) * 7.0)) / 7.0)), sin(((beats * 1.57) * 0.25))).y)).y), audio1).y).x), audio1).y, (uv.y * 1.5))).y), audio3).x - (length(uv) * 10.0))), 3.1416).y), audio1).x / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0))) * 7.0)) / 7.0), 0.0, 0.1) * 7.0)) / 7.0) - (tan(((beats * 3.14) * 0.5)) / 2.0)), 4.0), (beats * 0.25)).y).y / (1.3 / (uv.y * 8.0))), (uv.x * 2.0)), (beats * 0.25)).y / (1.3 / (uv.y * 8.0))), (sin(((beats * 1.57) * 0.5)) * 4.0))), audio2), (beats * 0.25)).y + (uv.x * 2.0))).y, (sin(((beats * 1.57) * 0.5)) * 4.0))).y / (1.3 / audio2)) * 7.0)) / 7.0) - (uv.y * 1.5)) + audio3)).x, (uv.x * 2.0)), (beats * 0.25)).x * 7.0)) / 7.0) / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0)))).y).y).y - (length(uv) * 10.0)) * 7.0)) / 7.0)), 3.1416).y).y, 0.0, 0.1)).y, (uv.y * 8.0)), (beats * 0.25)).y, (uv.x * 2.0)), (beats * 0.25)).x, (uv.x * 10.0))), (length(uv) * 10.0)), (beats * 0.25)).y, (tan(((beats * 3.14) * 0.5)) / 2.0)), (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y) * 7.0)) / 7.0)).y * 7.0)) / 7.0)), (uv.y * 1.5)).y)), (sin(((beats * 1.57) * 0.5)) * 4.0)).y), audio3), (beats * 0.25)).y), (uv.x * 10.0)), (beats * 0.25)).y, audio2))), sin(((beats * 1.57) * 0.25))).y - sin(((beats * 1.57) * 0.25))), 0.0, 0.1), sin(((beats * 1.57) * 0.25))), (tan(((beats * 3.14) * 0.5)) / 2.0)))), (length(uv) * 10.0)).y * 7.0)) / 7.0), 0.0, 0.1), 3.1416)), (uv.x * 10.0))), (uv.y * 8.0)).y), (uv.x * 10.0)).y, audio1)) * 7.0)) / 7.0) + audio1)).x) / (1.3 / (uv.y * 1.5)))) / 2.0)).y, 0.0, 0.1)).x * 7.0)) / 7.0), 0.0, 0.1) - audio2)))), (uv.y * 8.0)).x), (uv.y * 8.0)).x * 7.0)) / 7.0)), sin(((beats * 1.57) * 0.25))).y * 7.0)) / 7.0)) / (1.3 / audio2)) - audio2) + (sin(((beats * 1.57) * 0.5)) * 4.0)) * 7.0)) / 7.0)) - (uv.y * 8.0)) / (1.3 / sin(((beats * 1.57) * 0.25)))), (uv.x * 2.0))), audio2), (beats * 0.25)).y + 3.1416)).x).x), audio2), (beats * 0.25)).x), audio1).y, sin(((beats * 1.57) * 0.25))), (beats * 0.25)).x, audio2), (beats * 0.25)).y) * 7.0)) / 7.0)).y, sin(((beats * 1.57) * 0.25)))).x, 0.0, 0.1)) / (1.3 / (uv.x * 10.0))) / (1.3 / sin(((beats * 1.57) * 0.25)))), audio1), (beats * 0.25)).y, (length(uv) * 10.0)), (beats * 0.25)).x * 7.0)) / 7.0))), (uv.x * 2.0)), (beats * 0.25)).x, (uv.y * 8.0))), (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y) + (uv.y * 1.5)), 4.0))) - (length(uv) * 10.0))), sin(((beats * 1.57) * 0.25))).x)), audio2)) / 2.0)), (uv.y * 8.0))))), (uv.x * 2.0)) - (uv.x * 10.0))), (uv.x * 2.0)).x, (uv.y * 1.5)), (beats * 0.25)).y).y)).y), (length(uv) * 10.0)).y).x).y, (uv.y * 8.0)), (beats * 0.25)).y)) / 2.0), (uv.y * 8.0)))) / 2.0), audio2), (beats * 0.25)).y).x) * 7.0)) / 7.0)), sin(((beats * 1.57) * 0.25))).y, (uv.y * 1.5)), (beats * 0.25)).x), (length(uv) * 10.0)), (beats * 0.25)).y, 0.0, 0.1) * 7.0)) / 7.0) - 4.0), (uv.y * 1.5)) * 7.0)) / 7.0)), (uv.y * 8.0)).y, (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).x)))))), audio1).y * 7.0)) / 7.0)).y).x - sin(((beats * 1.57) * 0.25))), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y), (uv.y * 8.0)))).x).x) / 2.0), audio2), (beats * 0.25)).y, (uv.x * 2.0)))).x)), (length(uv) * 10.0)).y * 7.0)) / 7.0), 4.0)).x, 3.1416))), (length(uv) * 10.0)).x * 7.0)) / 7.0)) / 2.0)))) * 7.0)) / 7.0)).y, (length(uv) * 10.0)), (beats * 0.25)).x / (1.3 / sin(((beats * 1.57) * 0.25))))).x, audio1))), audio3), (beats * 0.25)).y), audio1).x, audio2)), (sin(((beats * 1.57) * 0.5)) * 4.0))) - (length(uv) * 10.0))).x, audio3), 3.1416), (beats * 0.25)).x), (sin(((beats * 1.57) * 0.5)) * 4.0)).y).y, (length(uv) * 10.0))), (uv.x * 2.0)), (beats * 0.25)).y).x * 7.0)) / 7.0) + (sin(((beats * 1.57) * 0.5)) * 4.0)) - (uv.x * 10.0))), 0.0, 0.1) - (uv.y * 8.0))).x, 0.0, 0.1) * 7.0)) / 7.0) - (sin(((beats * 1.57) * 0.5)) * 4.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)) / (1.3 / sin(((beats * 1.57) * 0.25)))), 4.0), (beats * 0.25)).y * 7.0)) / 7.0)).x - audio1) / (1.3 / audio1)), audio3)), audio2), (beats * 0.25)).x) * 7.0)) / 7.0)) * 7.0)) / 7.0)).x) / 2.0)), audio1).y / (1.3 / (uv.x * 2.0)))), (uv.x * 2.0)).y, 0.0, 0.1)), audio3).y + (length(uv) * 10.0))).x), (uv.x * 2.0)).x) - (uv.x * 2.0)) * 7.0)) / 7.0) + (uv.y * 1.5)) * 7.0)) / 7.0), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y, sin(((beats * 1.57) * 0.25))), (beats * 0.25)).x / (1.3 / (uv.y * 1.5)))))), audio3).x).x + sin(((beats * 1.57) * 0.25)))).x * 7.0)) / 7.0), (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y, 0.0, 0.1) - (tan(((beats * 3.14) * 0.5)) / 2.0)), (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).x, (uv.x * 2.0)), (uv.y * 8.0)), (beats * 0.25)).y) / 2.0), (length(uv) * 10.0)) / (1.3 / (length(uv) * 10.0))), 0.0, 0.95);
c = vec3((1.0 / (round((pR((uv * 5.0), smoothstep(pR(vec2(pR(vec2(pR((uv * 5.0), pR((uv * 1.5), (-pR((uv * 5.0), pR((uv * 5.0), length(vec2(sin(pR((uv * 1.5), (pR((uv * 1.5), (pR((uv * 1.5), smoothstep(pR(vec2((uv.y * 10.0), sin(pR(vec2((uv.x * 10.0), pR((uv * 5.0), length(vec2((length(vec2(smoothstep(sin((pR(vec2(pR(vec2((floor(((sin(smoothstep((-length(vec2(max(pR(vec2((round((pR(vec2((uv.y * 10.0), (sin(length(vec2(pR((uv * 1.5), pR(vec2((uv.x * 10.0), pR((uv * 5.0), sin(pR(vec2((uv.y * 10.0), pR(vec2((length(vec2((tan((tan(pR(vec2(smoothstep(max(pR((uv * 5.0), (smoothstep(cos(pR(vec2((length(vec2(pR((uv * 5.0), cos((floor(((-audio1) * 7.0)) / 7.0))).x, sin(((beats * 1.57) * 0.25)))) + sin(((beats * 1.57) * 0.25))), 3.1416), (beats * 0.25)).y), 0.0, 0.1) / (1.3 / audio3))).y, audio1), 0.0, 0.1), (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y) / 2.0)) / 2.0), audio2)) - audio1), audio2), (beats * 0.25)).x), (uv.y * 1.5)).y)).x), 4.0).x).x, (tan(((beats * 3.14) * 0.5)) / 2.0)))) + (uv.x * 2.0))), (sin(((beats * 1.57) * 0.5)) * 4.0)).y * 7.0)) / 7.0), (uv.x * 2.0)), (beats * 0.25)).y, (sin(((beats * 1.57) * 0.5)) * 4.0)), (uv.x * 10.0)))), 0.0, 0.1)) + audio2) * 7.0)) / 7.0), 3.1416), (beats * 0.25)).y, audio1), (beats * 0.25)).x / (1.3 / (uv.y * 1.5)))), 0.0, 0.1), 3.1416)) / (1.3 / audio3)), (uv.y * 1.5)))).y), (sin(((beats * 1.57) * 0.5)) * 4.0)).x)), (tan(((beats * 3.14) * 0.5)) / 2.0)).y, 0.0, 0.1)).x - sin(((beats * 1.57) * 0.25)))).x / (1.3 / audio2))).y), (length(uv) * 10.0)))).x).x)).x).y, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y, audio3), (beats * 0.25)).x, 0.0, 0.1)).y * 7.0)) / 7.0)), (1.0 / (-(round((pR(vec2(sin(pR((uv * 5.0), (floor(((floor((length(vec2((round((pR(vec2(pR((uv * 1.5), pR((uv * 5.0), pR((uv * 1.5), ((sin(pR(vec2((pR((uv * 5.0), ((pR((uv * 5.0), sin(cos((round((pR((uv * 5.0), (tan(pR(vec2((uv.x * 10.0), (tan(length(vec2((pR((uv * 1.5), (-sin(pR((uv * 5.0), pR(vec2((length(vec2(pR(vec2(pR(vec2((round(((floor(((-(pR(vec2((uv.x * 10.0), (tan((tan((tan(pR(vec2((uv.y * 10.0), pR((uv * 1.5), (floor(((-pR(vec2(pR(vec2(pR(vec2((uv.y * 10.0), length(vec2(pR(vec2((uv.x * 10.0), (round(((sin(((beats * 1.57) * 0.5)) * 4.0) * 7.0)) / 7.0)), (length(uv) * 10.0)).x, audio1))), (uv.y * 1.5)).y, 3.1416), (beats * 0.25)).x, audio2), (beats * 0.25)).y) * 7.0)) / 7.0)).x), 4.0).y) / 2.0)) / 2.0)) / 2.0)), (uv.y * 1.5)).x - sin(((beats * 1.57) * 0.25)))) * 7.0)) / 7.0) * 7.0)) / 7.0), (uv.x * 2.0)), (beats * 0.25)).y, 3.1416), (beats * 0.25)).y, (uv.y * 8.0))) / (1.3 / (uv.x * 2.0))), 3.1416), (beats * 0.25)).y).y))).x - audio2), audio3))) / 2.0)), (tan(((beats * 3.14) * 0.5)) / 2.0)).x) / 2.0)).y * 7.0)) / 7.0)))).x / (1.3 / audio2)) - (sin(((beats * 1.57) * 0.5)) * 4.0))).y - (uv.y * 1.5)), (uv.y * 1.5)), (beats * 0.25)).x) / (1.3 / (length(uv) * 10.0))) / (1.3 / 3.1416))).x).y).x, (length(uv) * 10.0)), (beats * 0.25)).x * 7.0)) / 7.0), (uv.x * 2.0))) * 7.0)) / 7.0) * 7.0)) / 7.0)).y), audio2), (beats * 0.25)).x * 7.0)) / 7.0))), (1.0 / pR(vec2(pR(vec2((floor((sin(pR(vec2((uv.y * 10.0), length(vec2(pR(vec2((-pR(vec2((uv.y * 10.0), (-(round(((pR(vec2((round((pR(vec2(pR(vec2(pR(vec2((uv.x * 10.0), pR((uv * 1.5), (cos(pR((uv * 5.0), pR((uv * 1.5), pR(vec2((uv.x * 10.0), pR(vec2((tan(length(vec2(cos((round(((round(((floor((pR(vec2((round((((-cos((floor(((-(max(max(pR(vec2((uv.y * 10.0), ((((floor(((length(vec2(pR((uv * 1.5), pR((uv * 1.5), smoothstep(pR(vec2((uv.y * 10.0), (round((pR((uv * 5.0), pR(vec2((uv.x * 10.0), pR(vec2((uv.x * 10.0), (pR((uv * 1.5), pR(vec2(pR(vec2((uv.x * 10.0), pR((uv * 1.5), (tan(pR((uv * 1.5), (floor(((pR((uv * 1.5), (-(uv.x * 10.0))).x / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0))) * 7.0)) / 7.0)).y) / 2.0)).x), audio1).x, 3.1416), (beats * 0.25)).x).y / (1.3 / 4.0))), audio2).x), (sin(((beats * 1.57) * 0.5)) * 4.0)).x).y * 7.0)) / 7.0)), (uv.x * 2.0)).y, 0.0, 0.1)).x).y, sin(((beats * 1.57) * 0.25)))) + (uv.x * 10.0)) * 7.0)) / 7.0) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))) - sin(((beats * 1.57) * 0.25))) / (1.3 / 3.1416))), (uv.y * 8.0)).y, (uv.x * 2.0)), audio1) - 3.1416)) * 7.0)) / 7.0))) / (1.3 / (uv.x * 10.0))) * 7.0)) / 7.0), 3.1416), (beats * 0.25)).y * 7.0)) / 7.0) * 7.0)) / 7.0) * 7.0)) / 7.0)), audio2))) / 2.0), (length(uv) * 10.0)), (beats * 0.25)).x), audio3).x).y).x) + (length(uv) * 10.0))).x), (tan(((beats * 3.14) * 0.5)) / 2.0)).x, 4.0), (beats * 0.25)).x, 3.1416), (beats * 0.25)).y * 7.0)) / 7.0), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y + audio1) * 7.0)) / 7.0))), sin(((beats * 1.57) * 0.25))).y), 3.1416), (beats * 0.25)).x, (uv.x * 10.0)))), 4.0).y) * 7.0)) / 7.0), (uv.y * 1.5)), (beats * 0.25)).y, (length(uv) * 10.0)), (beats * 0.25)).y));
c = (c * 0.9);
vec3 actualColor = vec3(1.0);
actualColor = (actualColor - (vec3(c.x) * r));
actualColor = (actualColor - (vec3(c.y) * g));
actualColor = (actualColor - (vec3(c.z) * b));
c = (vec3(l) * actualColor);
c = (c + (noise(pR(uv, Time), 0.5) * 0.021));
c = max(c, vec3(0.0));
c = (c / smoothstep(0.1, 0.3, (fract((beats / 2.0)) * 2.0)));
fsout_Color = vec4(c, 1.0);

}

