/*
 * This is a stripped down starter code for the
 * Assembly Summer 2019 Demo Coding Workshop
 * The original invitation code is very educational:
 * https://github.com/mrautio/graffathon19-demo-one-scene 
 */

// We suggest you use these libraries (and no others):
// Moonlander is a library for integrating Processing with GNU Rocket, https://github.com/anttihirvonen/moonlander
// GNURocket is a tool for synchronizing music and visuals in demoscene productions: https://github.com/rocket/rocket
import moonlander.library.*;
// Audio library for playing sound, http://code.compartmental.net/minim/
import ddf.minim.*;

// Some demo global variables 

// the time in seconds (will be taken from Moonlander / GNURocket every frame)
float now = 0.0;

// These control how big the opened window is.
// But you don't need not change these to develop in a smaller window!
// In fact, DON'T CHANGE THESE. They are optimal for Assembly 2019 Compo.
// ref. https://www.assembly.org/summer19/demoscene/rules
float CANVAS_WIDTH = 1920;
float CANVAS_HEIGHT = 1080;

Moonlander moonlander;

PFont font;

/*
 * Initialize the window
 */
 
void settings() {
  boolean fullscreen = true;
  
  if (fullscreen) {
    //Set the window fullscreen in desktop's native resolution
    fullScreen(P3D);
  } else {
    //open in a smaller window
    //Put some 16:9 aspect ratio resolution
    //like 800x450... do not edit CANVAS_WIDTH or CANVAS_HEIGHT
    //size((int)800,(int)450, P3D);
    size((int)1920,(int)1080, P3D);
  }
}

/*
 * Set up, and load all assets in the demo.
 * Make sure you include everything in the "data/" directory 
 * with your entry, and that the license of each asset allows
 * you to use it in this compo!
 */
 
ArrayList<PVector> startPositions = new ArrayList<PVector>();
ArrayList<PVector> endPositions = new ArrayList<PVector>();
ArrayList<PVector> Colors = new ArrayList<PVector>();

int CUBES = 13;

void setup() {
  // hide mouse cursor; you want to do this.
  noCursor();

  font = createFont("MS Comic Sans", 20);
 
 
  //for (int i=0; i<CUBES; i++)
  //{
  ////startPositions.add(new PVector(0,100*i, 0));
  //endPositions.add(new PVector(100*i,0,0));
  //}
  
  
  endPositions.add(new PVector(-1300,-250,-700));
  endPositions.add(new PVector(-1300,-550,-700));
  endPositions.add(new PVector(-1050,-830,-900));
  endPositions.add(new PVector(-1110,-750,-900));
  endPositions.add(new PVector(-1160,-670,-900));
  endPositions.add(new PVector(-1180,-590,-900));
  endPositions.add(new PVector(-1200,-510,-900));
  endPositions.add(new PVector(-1200,-430,-900));
  endPositions.add(new PVector(-1200,-350,-900));
  endPositions.add(new PVector(-1180,-270,-900));
  endPositions.add(new PVector(-1160,-190,-900));
  endPositions.add(new PVector(-1110,-110,-900));
  endPositions.add(new PVector(-1050,-30,-900));
 
  //too silly to use for loop
  startPositions.add(new PVector(-450,-200, 0));
  Colors.add(new PVector(30,200,30));
  startPositions.add(new PVector(-300,-250, 10));
  Colors.add(new PVector(30,190,30));
  startPositions.add(new PVector(-150,-275, 5));
  Colors.add(new PVector(30,180,30));
  startPositions.add(new PVector(0,-300, 0));
  Colors.add(new PVector(30,180,30));
  startPositions.add(new PVector(130,-270, 2));
  Colors.add(new PVector(30,180,30));
  startPositions.add(new PVector(270,-250, 0));
  Colors.add(new PVector(30,190,30));
  startPositions.add(new PVector(400,-220, 0));
  Colors.add(new PVector(30,200,30));
  startPositions.add(new PVector(-10, -150, 2));
  Colors.add(new PVector(30,0,30));
  startPositions.add(new PVector(-20, -10, 0));
  Colors.add(new PVector(30,0,30));
  startPositions.add(new PVector(-30, 110, 0));
  Colors.add(new PVector(35,0,30));
  startPositions.add(new PVector(-40, 210, 0));
  Colors.add(new PVector(40,0,30));
  startPositions.add(new PVector(-50, 310, 0));
  Colors.add(new PVector(45,0,30));
  startPositions.add(new PVector(-60, 410, 0));
  Colors.add(new PVector(50,20,30));
  //startPositions.add(new PVector(-70, 510, 0));
  //Colors.add(new PVector(30,40,80));
  

 
  //
  
  // Init & start moonlander
  // Great Hope is a tune by Vibe Mountain
  // Great Hops was downloaded from https://www.youtube.com/audiolibrary/music?nv=1
  int bpm = 120; // Tune's beats per minute. Set this according to your song.
  int rowsPerBeat = 4; // How many rows one beat consists of in the sync editor (GNURocket or so)
  moonlander = Moonlander.initWithSoundtrack(this, "Great_Hope.mp3", bpm, rowsPerBeat);
  moonlander.start();
  
  // Assembly has 60Hz maximum projector framerate, ref. https://www.assembly.org/summer19/demoscene/rules
  int fps = 60;
  frameRate(fps); 
  

}

void drawText() {
  if (moonlander.getValue("font:text") >= 0) {
    pushMatrix();
    scale((float)moonlander.getValue("font:scale"));
    textAlign(LEFT, CENTER);
    textFont(font);
    fill((int)(moonlander.getValue("font:r") * 1),(int)(moonlander.getValue("font:g") * 1),(int)(moonlander.getValue("font:b") * 1),(int)(moonlander.getValue("font:a") * 1));
    text("Your PC ran into a problem that it couldn't", (int)moonlander.getValue("font:x"), (int)moonlander.getValue("font:y")+10);
    text("handle, and now it needs to restart.", (int)moonlander.getValue("font:x"), (int)moonlander.getValue("font:y")+35);
    text("You can search for the error online: DEMO_MAKING_COMPO_CRITICAL_FAILURE", (int)moonlander.getValue("font:x"), (int)moonlander.getValue("font:y")+80);
    popMatrix();
  }
}

void drawMyStuff() {

float change = (float)moonlander.getValue("change"); //from moonlander
//int lukum = moonlander.getValue("lkm");
for (int i = 0; i<CUBES; i++){
  PVector start = startPositions.get(i);
  PVector end = endPositions.get(i);
  PVector colores = Colors.get(i);
  noiseDetail(1,1);
  float x = map(change+noise(millis()*0.01)/1000*50, 0, 1, start.x, end.x);
  float y = map(change+noise(millis()*0.01)/1000*50, 0, 1, start.y, end.y);
  float z = map(change+noise(millis()*0.01)/1000*50, 0, 1, start.z, end.z);
  pushMatrix();
  translate(x, y, z);
  
 if (change > 0 && change <1)
  {
    colores.x=random(0,255);
    colores.y=random(0,255);
    colores.z=random(0,255);
  }
  
 if (change >= 1  )
  {
    colores.x=255;
    colores.y=255;
    colores.z=255;
  }
  
  fill(colores.x, colores.y, colores.z);
  box(80);
  popMatrix();
 
}

drawText();

 
}

/*
 * This function is called every time a screen is drawn, ideally that would be 60 times per second
 */
void draw() {
  // update Rocket sync data  
  moonlander.update();

  now = (float)moonlander.getCurrentTime();
  float end = 17.0; //end production after 60 secs which is the maximum time allowed by the One Scene Compo
  if (now > end) {
    exit();
  }
  
  // Set the background color
  background((int)(moonlander.getValue("bg:r") * 0), //IP
             (int)(moonlander.getValue("bg:g") * 255),
             (int)(moonlander.getValue("bg:b") * 255),
             (int)(moonlander.getValue("bg:a") * 255));
  
  /*
   * Center coordinates to screen and make the window and canvas resolution independent
   * This is because actual window in full screen on a 4K monitor has more pixels than FullHD resolution
   * so scaling is needed to ensure that all objects (3D and 2D) are in correct places regardless of the desktop resolution
   */
  translate(width/2, height/2, 0);
  scale(width/CANVAS_WIDTH,height/CANVAS_HEIGHT,width/CANVAS_WIDTH);

  // Enable lights and depth testing to ensure that 3D meshes are drawn in correct order
  lights();
  hint(ENABLE_DEPTH_TEST);

  drawMyStuff();
}
