#version 330 core

// inputz
in vec2 UV;

uniform vec2 iResolution;
uniform float iTime;
uniform sampler2D iChannel0;

// outputz
out vec4 fragColor;

//// BLOOM TOOLBOX
const int kBlurWidth = 20;
//// BLOOM TOOLBOX

void main()
{
    fragColor = vec4(0.0);
    float n = 0.0;
    for (int i = -kBlurWidth; i <= kBlurWidth; i += 1) {
        vec3 texVal = texelFetch(iChannel0, ivec2(gl_FragCoord)
                                 + ivec2(vec2(1.0/sqrt(2.0), 1.0/sqrt(2.0)) * float(i)),
                                 0).rgb;
        fragColor += vec4(texVal, 1.0);
        n += 1.0;
    }
    fragColor /= vec4(n);
}