//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D texSource : register(t0);
Texture2D texImage1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b0)
{
    float g_fTime;
    float g_fFloat1;    // xpos
    float g_fFloat2;    // ypos
    float g_fFloat3;    // spread size (bigger number means smaller/sharper)
    float g_fFloat4;    // distance
    float g_fFloat5;    // brightness change
    float g_fFloat6;
    float g_fSeed;
};


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;
    float2 vecTexCoord = input.vecTexCoord.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord/* * float2(1, 800.06f/600.0f)*/, 0, 1);
    output.vecTexCoord = input.vecTexCoord.xy;
//    output.vecTexNoise = texImage1.SampleLevel(sampNearestWrap, float2(g_fSeed + g_fFloat1, 0) * 1, 0).rg + (input.vecTexCoord - 0.5) * 1 * float2(0,g_fFloat2);
    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    float2 vecTexCoord = input.vecTexCoord - 0.5 - float2(g_fFloat1, g_fFloat2);

    float2 vecAspect = float2(1280.0f / 720.0f, 1);
    float fDistance = length(vecTexCoord * vecAspect);
    float fSpreadStrength = 1 - pow(min(abs(g_fFloat4 - fDistance) * g_fFloat3, 1), 1.6);

    float2 vecSpreadDirection = normalize(vecTexCoord);

    float4 vecColour = float4(texSource.Sample(sampLinearClamp, input.vecTexCoord + +0.05 * fSpreadStrength * vecSpreadDirection).r,
                              texSource.Sample(sampLinearClamp, input.vecTexCoord + +0.02 * fSpreadStrength * vecSpreadDirection).g,
                              texSource.Sample(sampLinearClamp, input.vecTexCoord + -0.01 * fSpreadStrength * vecSpreadDirection).b,
                              1);

    if (fDistance > g_fFloat4)
    {
        vecColour.rgb *= g_fFloat5;
    }
    
    //    vecColour.r = fSpreadStrength;
    return vecColour;
}
