//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D tex0 : register(t0);
Texture2D tex1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b2)
{
    float g_fTime;
    float g_fFloat1;    // X Position
    float g_fFloat2;    // Strength
    float g_fFloat3;
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;
};

#define PI      3.1415926535897932384626433832795
#define TWOPI   6.283185307179586476925286766559


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

    float2 vecTexCoord = (input.vecTexCoord.xy * float2(2, -2) + float2(-1, 1)) * 1.0;
    output.vecPosition = float4(vecTexCoord * float2(1, 1280.0f / 720.0f), 0, 1);
    output.vecTexCoord = (input.vecTexCoord.xy)+float2(g_fFloat1 + floor(g_fFloat1 * 4) * 12.25, -0.02);

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    float4 vecResult = 0;
    float y = (floor(input.vecTexCoord.y * 256 / 25.6 * 2) / 256);
    if (y > 0.04 && y < 0.0525)
    {
        float x = (floor(input.vecTexCoord.x * 256 / 25.6 * 2) / 256);
        float4 vecCellStrength = tex0.Sample(sampNearestWrap, float2(x, y));
        if (vecCellStrength.a > 0.25)
        {
            float f = tex1.Sample(sampLinearWrap, input.vecTexCoord * 20).r;
            vecResult = float4(1, 1, 1, f * vecCellStrength.a * g_fFloat2);
        }
    }
    else
    {
        discard;
    }
    return vecResult;
}
