//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D tex0 : register(t0);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b0)
{
    float g_fTime;
    float g_fFloat1;
    float g_fFloat2;
    float g_fFloat3;
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;
};


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexNoise1 : TEXCOORD0;
    float2 vecTexNoise2 : TEXCOORD1;
    float2 vecTexNoise3 : TEXCOORD2;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

    float2 vecTexCoord0 = input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1);

     output.vecPosition = float4(vecTexCoord0/* * float2(1, 800.06f/600.0f)*/, 0, 1);
//     output.vecTexNoise1 = input.vecTexCoord0.xy;
//     output.vecTexNoise2 = input.vecTexCoord0.xy;

    output.vecTexNoise1 = tex0.SampleLevel(sampNearestWrap, float2(g_fTime, g_fTime) * 1.23, 0).rg + (input.vecTexCoord0 - 0.5) * 1*2;
    output.vecTexNoise2 = tex0.SampleLevel(sampNearestWrap, float2(g_fTime, g_fTime) * 2.07, 0).gb + (input.vecTexCoord0 - 0.5) * 1*4;
    output.vecTexNoise3 = tex0.SampleLevel(sampNearestWrap, float2(g_fTime, g_fTime) * 3.55, 0).gb + (input.vecTexCoord0 - 0.5) * 1*8;

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    float fGreyscale = dot(tex0.Sample(sampNearestWrap, input.vecTexNoise1).rgb, float3(0.222, 0.707, 0.071)) * 1/2 +
                       dot(tex0.Sample(sampNearestWrap, input.vecTexNoise2).brg, float3(0.222, 0.707, 0.071)) * 1/4 + 
                       dot(tex0.Sample(sampNearestWrap, input.vecTexNoise2).brg, float3(0.222, 0.707, 0.071)) * 1/8;
    return float4(fGreyscale, fGreyscale, fGreyscale, g_fFloat1);
}
