//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D texSource : register(t0);
Texture2D texImage1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b0)
{
    float g_fTime;
    float g_fFloat1;    // Mosaic scale
    float g_fFloat2;    // Mix
    float g_fFloat3;
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;
};


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

    float2 vecTexCoord = input.vecTexCoord * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord/* * float2(1, 1280.0f / 720.0f)*/, 0, 1);
    output.vecTexCoord = input.vecTexCoord - 0.5;

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
	float2 vecAspect = float2(1280.0f / 720.0f, 1.0);

	float2 vecMosaicCoord = ceil(input.vecTexCoord * vecAspect * g_fFloat1) / (vecAspect * g_fFloat1) -(0.5 / g_fFloat1);
	float4 vecMosaicColour = texSource.Sample(sampLinearClamp, vecMosaicCoord + 0.5);

	float2 vecShapeCoord = (input.vecTexCoord * vecAspect * g_fFloat1) % 1;
	float fShape = 1 - pow(length(abs(vecShapeCoord.xy * 2) - 1), 10);
	vecMosaicColour *= fShape;

	float4 vecSourceColour = texSource.Sample(sampLinearClamp, input.vecTexCoord + 0.5);

	return lerp(vecSourceColour, vecMosaicColour, g_fFloat2);
}
