//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D tex0 : register(t0);
Texture2D tex1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b2)
{
    float g_fTime;
    float g_fFloat1;    // Strength
    float g_fFloat2;
    float g_fFloat3;
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;
};

#define PI      3.1415926535897932384626433832795
#define TWOPI   6.283185307179586476925286766559


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

    float2 vecTexCoord = input.vecTexCoord.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord * float2(1, 1280.0f / 720.0f), 0, 1);
    output.vecTexCoord = input.vecTexCoord.xy * float2(1, 0.75) + float2(-0.025, 0);

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    int iStrip = (input.vecTexCoord * (1280.0f / 64.0f));
    float fResult = 0;
    for (int i = 0; i < 4; i++)
    {
        float fTime = 12.3 + i + g_fTime;

        float fSpeed = tex1.Sample(sampLinearWrap, float2(iStrip * (0.251 + i * 0.0123) + (i * 0.0377), 0));
        if (fSpeed > 0.5)
        {
            fSpeed = lerp(0.001, 0.02, (fSpeed - 0.5) * 2);
        }
        else
        {
            fSpeed = lerp(-0.001, -0.02, fSpeed * 2);
        }
        float2 vecTexCoord = input.vecTexCoord + float2(0, (5.0 + fTime) * fSpeed);
        float fGreyscale = tex0.Sample(sampNearestWrap, vecTexCoord).r;

        float fFade = tex1.Sample(sampLinearWrap, float2(i * 0.1, g_fTime * 0.001));

        fResult += fGreyscale * fFade;
    }
    return fResult * g_fFloat1;
}
