//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D texDiffuse : register(t0);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData : register(b3)
{
    matrix g_matWorld;
    matrix g_matView;
    matrix g_matProjection;
};

cbuffer GolbalFilamentData : register(b2)
{
    float g_fTime;
    float g_fDiameter;
    float g_fLength;
    float g_fNumPoints;
    float g_fColourSpeed;
    float gfrpad1, gfrpad2, gfrpad3;
};

StructuredBuffer<float4> g_aPoints : register(t7);


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    uint iInstanceID : SV_InstanceID;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Support functions
//--------------------------------------------------------------------------------------
float3 catmullRom(float3 v[4], float t)
{
    float t2 = t * t;
    float t3 = t2 * t;
    return 0.5f * ((2.0f * v[1]) +
                   (-v[0] + v[2]) * t +
                   (2.0f * v[0] - 5.0f * v[1] + 4 * v[2] - v[3]) * t2 +
                   (-v[0] + 3.0f * v[1] - 3.0f * v[2] + v[3]) * t3);
}

#define iNumPoints 6
float3 getPosition(int iPointBase, float fTime)
{
    float3 avecPoints[4];
    avecPoints[0] = g_aPoints[iPointBase + floor(fTime + 0)];// % g_fNumPoints];
    avecPoints[1] = g_aPoints[iPointBase + floor(fTime + 1)];// % g_fNumPoints];
    avecPoints[2] = g_aPoints[iPointBase + floor(fTime + 2)];// % g_fNumPoints];
    avecPoints[3] = g_aPoints[iPointBase + floor(fTime + 3)];// % g_fNumPoints];
    return catmullRom(avecPoints, frac(fTime));

//     float3 avecSrcPoints[iNumPoints] =
//     {
//         float3(-10, 0, 0),
//         float3(0, 10, 0),
//         float3(20, 0, -5),
//         float3(0, -10, 0),
//         float3(10, -20, 5),
//         float3(20, -20, 7),
//     };
//     float3 avecPoints[4];
//     avecPoints[0] = avecSrcPoints[(fTime + 0) % iNumPoints] * 10;
//     avecPoints[1] = avecSrcPoints[(fTime + 1) % iNumPoints] * 10;
//     avecPoints[2] = avecSrcPoints[(fTime + 2) % iNumPoints] * 10;
//     avecPoints[3] = avecSrcPoints[(fTime + 3) % iNumPoints] * 10;
//     return catmullRom(avecPoints, frac(fTime));

//    float fCirlceRadius = 20;
//    return float3(sin(fTime) * fCirlceRadius, cos(fTime) * fCirlceRadius, 0);
}

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

    const matrix matWorldView = mul(g_matWorld, g_matView);
    const matrix matWorldViewProjection = mul(matWorldView, g_matProjection);

    const int iFilimentID = input.iInstanceID;
    const float fTime = g_fTime + ((iFilimentID * 1234.5678) % 1);
    const float fTime1 = fTime + (input.vecPosition.x * g_fLength);
    const float fTime2 = fTime + (input.vecPosition.x * (g_fLength + 1));

    const float3 vecBasePosition1 = getPosition(iFilimentID * g_fNumPoints, fTime1);
    const float3 vecBasePosition2 = getPosition(iFilimentID * g_fNumPoints, fTime2);
    const float fMovementSpeed = saturate(length(vecBasePosition2 - vecBasePosition1) * g_fColourSpeed);

    const float3 vecFwd = normalize(vecBasePosition2 - vecBasePosition1);
    const float3 vecWorldUp = float3(0, 1, 0);
    const float3 vecWorldRight = float3(1, 0, 0);
    float3 vecUp, vecRight;
    if (0)//abs(dot(vecFwd, vecWorldUp)) < 0.5)
    {
        vecRight = normalize(cross(vecFwd, vecWorldUp));
        vecUp = cross(vecFwd, vecRight);
    }
    else
    {
        vecRight = normalize(cross(vecFwd, vecWorldRight));
        vecUp = cross(vecFwd, vecRight);
    }

    const float fAngle = input.vecPosition.y;
    const float fSize = input.vecPosition.z;
    const float3 vecPosition = vecBasePosition1 + sin(fAngle) * vecUp * fSize * g_fDiameter + cos(fAngle) * vecRight * fSize * g_fDiameter;

    output.vecPosition = mul(float4(vecPosition, 1), matWorldViewProjection);
//    output.vecWorldPosition = mul(float4(vecPosition, 1), matWorld);
//    output.vecNormal = normalize(mul(input.vecNormal, matWorld));
    output.vecTexCoord0 = float2(input.vecPosition.x, fMovementSpeed);

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    return texDiffuse.Sample(sampLinearClamp, input.vecTexCoord0);
}
