//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D tex0 : register(t0);
//Texture2D tex1 : register(t1);
//SamplerState sampLinearClamp : register(s0);
//SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
//SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b2)
{
    float g_fTime;
    float g_fFloat1;    // Strength
    float g_fFloat2;    // Distance
    float g_fFloat3;
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;
};

#define PI      3.1415926535897932384626433832795
#define TWOPI   6.283185307179586476925286766559


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

    float2 vecTexCoord = input.vecTexCoord.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord * float2(1, 1280.0f / 720.0f), 0, 1);
    output.vecTexCoord = input.vecTexCoord.xy;

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
//    float2 vOffset = input.vecTexCoord - float2(0.298, 0.453);
    float2 vOffset = input.vecTexCoord - float2(0.608, 0.453);
    float d = length(vOffset) * 10;
    float v = d / g_fFloat2;
    if (v < 1) {
        v = 1-pow(v,5);
        float n1 = tex0.Sample(sampLinearWrap, float2(g_fTime * 0.006, 0) + input.vecTexCoord * 0.5).r;
        float n2 = tex0.Sample(sampLinearWrap, float2(0, g_fTime * -0.02) + input.vecTexCoord * 0.4).a;
        float n3 = tex0.Sample(sampLinearWrap, float2(g_fTime * -0.007, 0) + input.vecTexCoord * 0.14).g;
        float n4 = tex0.Sample(sampLinearWrap, float2(0, g_fTime * 0.0014) + input.vecTexCoord * 0.03).b;
        float n = n1 * 0.1 + 
                  n2 * 0.1 + 
                  n3 * 0.3 + 
                  n4 * 0.5;
        return v * g_fFloat1 * n;
    }
    return 0;
}
