#version 330

// OpenGL 3.0 -> GLSL 1.30
// OpenGL 3.3 -> GLSL 3.30
// a projection transformation to apply to the vertex' position
uniform mat4 uProjectionMatrix;
uniform mat4 uWorldMatrix;
uniform mat4 uViewMatrix;

// IN
// attributes of our vertex
in vec3 aPosition;
in vec3 aNormal;
in vec2 aTexCoord;

// OUT
out vec3 wPosition;
out vec3 fPosition;

out vec3 wNormal;
out vec3 fNormal;

out vec2 fTexCoord;

void main()
{
	// gl_Position is a special variable of OpenGL that must be set
	vec4 worldPos = uWorldMatrix * vec4(aPosition, 1.0);
	vec4 viewPos = uViewMatrix * worldPos;
	gl_Position =  uProjectionMatrix * viewPos;
	
	wPosition = vec3(worldPos);
	fPosition = vec3(viewPos);

	wNormal = normalize(mat3(transpose(inverse(uWorldMatrix))) * aNormal);
	fNormal = normalize(mat3(transpose(inverse(uViewMatrix * uWorldMatrix))) * aNormal);

	// Tex coord adjustments here !
	fTexCoord = vec2(aTexCoord.x, 1 - aTexCoord.y);
}

