#version 330

uniform mat4 uWorldMatrix;
uniform mat4 uViewMatrix;
uniform mat4 uProjectionMatrix;
uniform float ucTexYMax;

in vec3 aPosition;
in vec2 aTexCoord;

out vec2 fTexCoord;

void main()
{
	vec4 position = uProjectionMatrix * uViewMatrix * uWorldMatrix * vec4(aPosition, 1.0f);
	position.z = position.w; // Always max depth
	gl_Position =  position;
	
	fTexCoord = vec2(aTexCoord.x, 1 - (aTexCoord.y * ucTexYMax));
}

