#version 330

uniform mat4 uWorldMatrix;
uniform mat4 uProjectionMatrix;


in vec3 aPosition;
in vec2 aTexCoord;

out vec2 fTexCoord;

void main()
{
	// gl_Position is a special variable of OpenGL that must be set
	
	// Left border of screen is -1; I want to map x=0 there
	// Top border is 1.0, map y=0 there
	/* (-1,1)	(1,1)
	 * 
	 * 
	 * 	(-1,-1)	(1,-1)
	 */
	
	// Gui Rectangle comes in as
	// (0,0) to (1, -1)
	
	// Apply scale.
	// Apply position. It is between 0 and 1
	vec4 position = uWorldMatrix * vec4(aPosition.x, aPosition.y, aPosition.z, 1.0);
	position.z = -1.0f; // Scale must not affect Z, set back to 0
	position = uProjectionMatrix * position;
	gl_Position = position;
	fTexCoord = vec2(aTexCoord.x, 1 - aTexCoord.y);
}

