#version 430

layout(binding=0, r32i) uniform iimage2D pardexBucketCounts;
layout(binding=1, r32i) uniform iimage2D pardexBucketPrefix;

uniform float loop = 0.0;
uniform float wkw = 0.0;


ivec2 getTrip(int idt) {
    ivec2 triBufSize = imageSize(pardexBucketPrefix);
    ivec2 trip;
    trip.y = idt/triBufSize.x;
    trip.x = idt-trip.y*triBufSize.x;
   // trip.y = 0;
    return trip;
}

int getInd(ivec2 uvi) {
    return uvi.x+uvi.y*int(wkw);
}

void main() {
    ivec2 uv = ivec2(gl_FragCoord.xy);


    int d2 = int(pow(2.0, loop))-1;
    int d2m1 = int(pow(2.0, loop+1.0))-1;
    int ib = getInd(uv)*int(pow(2.0, loop+1.0));
    int i0 = ib+d2;
    int i1 = ib+d2m1;


    if (loop < 0.5) {
        int v0 = imageLoad(pardexBucketCounts, getTrip(i0)).x;
        int v1 = imageLoad(pardexBucketCounts, getTrip(i1)).x;

        imageStore(pardexBucketPrefix, getTrip(i0), ivec4(v0));
        imageStore(pardexBucketPrefix, getTrip(i1), ivec4(v0+v1));

    } else {
        int v0 = imageLoad(pardexBucketPrefix, getTrip(i0)).x;
        int v1 = imageLoad(pardexBucketPrefix, getTrip(i1)).x;

        imageStore(pardexBucketPrefix, getTrip(i1), ivec4(v0+v1));
    }
/*
    float loopLim = 18.0;
    if (loop > (loopLim-0.5) && loop < (loopLim+0.5)) {
        //imageStore(pardexBucketPrefix, uv+ivec2(2,0), ivec4(11));
        //imageStore(pardexBucketPrefix, uv+ivec2(1,0), ivec4(110));
        //imageStore(pardexBucketPrefix, uv+ivec2(0,0), ivec4(110));
        imageStore(pardexBucketPrefix, uv+ivec2(0,0), ivec4(0));
    }
*/
//    imageStore(pardexBucketPrefix, uv, 1);

    discard;
}
