import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: tonemap
    name: "tonemap"
    effectName: "Tonemap"
    enabled: syncRoot("tonemap.ON")
    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    Shader {
        file: "tonemap"
        ShaderParam {
            paramName: "g_preBright"
            paramValue: sync(tonemap.name+".preBright")
        }
        ShaderParam {
            paramName: "g_exp"
            paramValue: syncOsc(tonemap.name+".exp")
        }
        ShaderParam { paramName: "g_lowLimit"; paramValue: sync(tonemap.name+".lowLimit") }
        ShaderParam { paramName: "g_highLimit"; paramValue: sync(tonemap.name+".hiLimit") }



        ShaderParam { paramName: "g_solarLimit"; paramValue: sync(tonemap.name+".solarLimit", 1.0) }
        ShaderParam { paramName: "g_solarAmp"; paramValue: sync(tonemap.name+".solarAmp", 0.0) }

    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
    }
}

