import QtQuick 2.4

import AdaptDemoSystem 1.0

GroupBase {
  property bool enabledIn: true
  enabled: syncRootOn(effect.name, effectName) & enabledIn;

  function syncOff(n) {
    return 0.0;
  }
  property var syncOrig
  property var syncFFTOrig

  function processEnabled(e) {
    if (e) {
      if (syncOrig !== undefined) {
        impl.syncIn = syncOrig;
      }
      if (syncFFTOrig !== undefined) {
        impl.syncFFTIn = syncFFTOrig;
      }
    } else {
      if (syncOrig === undefined) {
        syncOrig = impl.syncIn;
      }
      if (syncFFTOrig === undefined) {
        syncFFTOrig = impl.syncFFTIn
      }
      impl.syncIn = syncOff;
      impl.syncFFTIn = syncOff;
    }
  }

  onEnabledChanged: {
    processEnabled(enabled);
  }

}
