import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
    id: blurReflect
    name: "reflectBlur"
    effectName: "ReflectBlur"

    Blit {
      textureRT: "screenBuffer"
      blitRT: 0
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
        textureWrap: "clamp"
    }

    BlurRtImpl {
      name: blurReflect.name
      textureRT: "screenBuffer"
      targetTextureRT: "bgBlur"
    }

    Shader {
        file: "fx/_SharedQML/reflectMix"
    }
    Texture {
        textureUnit: 0
        textureRT: "bg"
    }
    Texture {
        textureUnit: 1
        textureRT: "bgBlur"
    }
    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: 0.0
        }
        ShaderParam {
            paramName: "overlayAlpha"
            paramValue: 1.0
        }
        ShaderParam {
            paramName: "g_overlayScale"
            paramValue: 1.0
        }
        ShaderParam { paramName: "g_addBlend"; paramValue: sync("reflect.addBlend") }
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }

}
