import QtQuick 2.3
import AdaptDemoSystem 1.0

// Averages the given 256x256 sized texture values
// and provides the resulting 1x1 size texture rgba values
Group {
    id: average
    name: "average"
    effectName: "BlurRt"
    property string shader: "fx/_SharedQML/average"
    property string textureRT

    // works now only with 256x256 texture size....
    property int texW: 256
    property int texH: 256

    property string textureWrap: "clamp"

    property real posX: 0.0
    property real posY: 0.0

    property int k: 0

    function getX() { return bb8.getPixel(k, k, 0); }
    function getY() { return bb8.getPixel(k, k, 1); }
    function getZ() { return bb8.getPixel(k, k, 2); }

    Texture {
        id: bb8
        textureRT: "avgBuffer8"
        readData: true
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "avgBuffer0"
            format: "RGBA32F"
            width: average.texW
            height: average.texH
        }
        Texture {
            textureUnit: 0
            textureRT: average.textureRT
        }
        Shader {
            file: "fx/_SharedQML/drawRtTexel"
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            blendMode: "off"
        }
    }

    Repeater {
        model: 8
        delegate: Group {
            RenderTarget {
                RenderTargetLayer {
                    textureRT: "avgBuffer"+String(index+1)
                    format: "RGBA32F"
                    width: average.texW/Math.pow(2, index+1)
                    height: average.texH/Math.pow(2, index+1)
                }
                Texture {
                    textureUnit: 0
                    textureRT: "avgBuffer"+String(index)
                    textureWrap: average.textureWrap
                }
                Shader { file: shader }
                DrawVB {
                    type: "quad"
                    depthTest: false
                    depthWrite: false
                    blendMode: "off"
                    drawBuffers: 1

                    ShaderParam { paramName: "g_sourceW"; paramValue: average.texW/Math.pow(2, index) }
                    ShaderParam { paramName: "g_sourceH"; paramValue: average.texH/Math.pow(2, index) }
                    ShaderParam { paramName: "g_destW"; paramValue: average.texW/Math.pow(2, index+1) }
                    ShaderParam { paramName: "g_destH"; paramValue: average.texH/Math.pow(2, index+1) }
                }
            }
        }
    }
}
