#version 430

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNorm;
layout(binding=2) uniform sampler2D texEnv;
layout(binding=3) uniform sampler2D texPrevFrame;
layout(binding=4) uniform sampler2D texPrevBlurFrame;
layout(binding=5) uniform sampler2D texPrevNorm;



in vec4 posG;
in vec3 normalG;
in vec3 normalWSG;
in vec2 uvG;
in vec3 tangentG;
in vec3 colorG;
in vec4 posW;
in vec4 posInst;
in vec4 randG;
in vec3 mirrorG;


layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;
layout(location = 2) out vec4 frag3; // emitBuf


uniform float g_instLayer = 0.0;
uniform float g_time;

uniform float g_uvOfsX = 0.0;
uniform float g_uvOfsY = 0.0;
uniform vec4 g_uvScale = vec4(1.0);

uniform float g_texBrightness = 1.0;

uniform float g_emitNew = 0.0;

uniform float g_prevAmount = 0.0;
uniform float g_prevBlurAmount = 0.0;


uniform float g_cubesDiv = 16.0;
uniform float g_spread = 8.0;
uniform float g_worldPos = 1.0;

uniform float g_genUV = 0.0;


uniform mat4 modelViewMatrix;
uniform mat4 modelViewInvMatrix;
uniform mat4 viewInvMatrix;
uniform mat4 viewMatrix;
uniform mat4 projectionMatrix;
uniform mat4 projectionInvMatrix;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;


uniform float g_prevBlurType = 1.0;


uniform float g_bump = 0.0;

uniform float g_animHeight = 0.0;

const float zFar = 1.0;
const float zNear = 0.0;

vec4 CalcEyeFromWindow(in vec3 windowSpace) {
    vec3 ndcPos;
    vec4 viewport = vec4(0.0, 0.0, g_windowWidth, g_windowHeight);
    ndcPos.xy = ((2.0 * windowSpace.xy) - (2.0 * viewport.xy)) / (viewport.zw) - 1;
//    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
    vec4 clipPos;
    clipPos.w = projectionMatrix[3][2]/(ndcPos.z-(projectionMatrix[2][2]/projectionMatrix[2][3]));
    clipPos.xyz = ndcPos * clipPos.w;
    return projectionInvMatrix * clipPos;
}

#define PI 3.1415926

vec2 latlong(vec3 v) {
  v = normalize(v);
  float theta = acos(v.z); // +z is up
  float phi = atan(v.y, v.x) + PI;
  return vec2(phi, theta)*vec2(.1591549, .6366198);
}


vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
  return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

uniform vec4 g_mirrorX = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorX on/off, .y: mirrorXPos, .z: mirrorXClip
uniform vec4 g_mirrorY = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorY on/off, .y: mirrorYPos, .z: mirrorYClip
uniform vec4 g_mirrorZ = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorZ on/off, .y: mirrorZPos, .z: mirrorZClip


uniform float g_texAmbient;

uniform float g_alpha;

uniform vec4 g_uvRandom;

uniform mat4 modelMatrix;
uniform float g_timeStep;


// pala flow emit stuff
uniform float g_emitThr = 0.0;
uniform float g_emitAmp = 1.0;


// emit particles stuff

layout(binding=0, offset=0) uniform atomic_uint ac;
layout(binding=0, rgba16f) uniform image2D emittedPartPos;
layout(binding=1, rgba16f) uniform image2D emittedPartVel;
layout(binding=2, rgba16f) uniform image2D emittedPartCol;

uniform float g_emitColorThr = 0.01;
uniform float g_emitVelX = 0.0f;
uniform float g_emitVelY = 0.0f;
uniform float g_emitVelZ = 0.0f;
uniform float g_emitVelAmp = 1.0;

uniform float g_emitPercent = 0.0;
uniform float g_vortexAngSpeed = 0.0;

uniform float g_randEmitPos = 0.10;
uniform float g_emitGrayness = 0.0;

void emitParticles(vec3 norm) {
    vec2 norkor = vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight);
    float de = 100.0*rand(norkor.xy*1.0+g_randEmitPos*vec2(sin(g_time*6.69), cos(g_time*1.320)));
    float ep = g_emitPercent*g_timeStep/(0.07);
    float br = dot(vec3(1.0), frag.rgb)*frag.a;
    if (de > 100.0-ep && br*100.0>g_emitColorThr) {
        uint counter = atomicCounterIncrement(ac);
        uint cy = counter/(1280);
        uint cx = counter-uint(cy*1280);
        ivec2 listCoord = ivec2(cx,cy);
        vec3 rado = normalize(vec3(posW.xyz));
        vec3 uppo = vec3(0.0, 1.0, 0.0);
        vec3 radde = cross(rado,uppo);
        vec4 emitVel = vec4(g_emitVelX, g_emitVelY, g_emitVelZ, 0.0)+vec4(radde, 0.0)*g_vortexAngSpeed;
        vec3 emitCol = frag.rgb*frag.a;
        emitCol = (1.0-g_emitGrayness)*emitCol+g_emitGrayness*vec3(dot(vec3(1.0), frag.rgb));

      //  imageStore(emittedPartPos, listCoord, modelMatrix*vec4(posW.xyz, posW.w));
        imageStore(emittedPartPos, listCoord, vec4(posW.xyz+vec3(0.0, 0.0, 0.0), posW.w));
        imageStore(emittedPartVel, listCoord, emitVel);
       // float nb = (dot(norm, vec3(0.0, -1.0, 0.0))*0.5+0.5);
        float nb = 1.0;
        imageStore(emittedPartCol, listCoord, vec4(emitCol*20.0*nb, 0.0));
       // frag.rgb = vec3(1.0);
    }
}

void main() {

  vec3 normal = normalG;
  vec2 uv = uvG;
  vec3 tangent = tangentG;
  vec3 color = colorG;

  if (mirrorG.x*(posW.x-g_mirrorX.y)*g_mirrorX.z > 0.0 ||
      mirrorG.y*(posW.y-g_mirrorY.y)*g_mirrorY.z > 0.0 ||
      mirrorG.z*(posW.z-g_mirrorZ.y)*g_mirrorZ.z > 0.0) {
          discard;
  }

//  if (posW.x-g_mirrorX.y < 0.0) discard;

  vec2 randUv = g_uvScale.xy+vec2(randG.x);
  randUv = min(max(randUv, vec2(g_uvRandom.y)), vec2(g_uvRandom.z));

  vec2 myUv = posInst.xy*randUv+vec2(0.5, 0.5);
  if (g_genUV < 0.5) {
    myUv = uv*randUv;
  }
  myUv += randG.yz;
  myUv.y *= -1.0;
  myUv.x += g_uvOfsX;
  myUv.y += g_uvOfsY+g_animHeight*floor(fract((floor(randG.w/1.0-0.5)/4.0)+0.01)*4.0);

 vec4 diffuse = texture2D(tex, myUv.xy);
 diffuse.rgb *= diffuse.rgb;
 diffuse.rgb *= g_texBrightness;

 diffuse.rgb += vec3(g_texAmbient);


 //diffuse.rgb *= diffuse.rgb;
// vec4 diffuse = 10.1*vec4(1.0);


 //diffuse += 4.0*texture2D(tex, myUv.xy*10.0)+0.1*vec4(1.0);


 // diffuse.r = pow(diffuse.r, 2.5);
 // diffuse.g = pow(diffuse.g, 1.10);
 // diffuse.b = pow(diffuse.b, 0.70);

  vec3 lightPos = vec3(0.0*cos(g_time*2.0), 0.0, 5.0);
  vec3 surfPos = vec3(0.0f, 0.0f, 0.0f);
  vec3 lightDir = lightPos-surfPos;

  float lightDist = sqrt(dot(lightDir, lightDir));

  vec3 myNormal = normal;
  vec3 biTangent = cross(myNormal, tangent);

//  float bumpX = 0.0*(texture2D(tex, myUv.xy+vec2(1.0/512.0, 0.0)).g-texture2D(tex, myUv.xy+vec2(-1.0/512.0, 0.0)).g);
//  float bumpY = 0.0*(texture2D(tex, myUv.xy+vec2(0.0, 1.0/512.0)).g-texture2D(tex, myUv.xy+vec2(0.0, -1.0/512.0)).g);


  vec4 normFromTex = texture2D(texNorm, myUv*1.0);
  float bumpX = -(normFromTex.x-0.5)*g_bump;
  float bumpY = -(normFromTex.y-0.5)*g_bump;

//  bumpX = 0.0;
//  bumpY = 0.0;

  myNormal += tangent*bumpX + biTangent*bumpY;

  myNormal = normalize(myNormal);


  float normalLen = sqrt(dot(myNormal, myNormal));

  float d = dot(lightDir, myNormal)/(lightDist*normalLen);
  d = clamp(d, 0.0, 1.0);

  //d = d*0.35+pow(d, 128.0f);
  //frag = vec4(d, d, d, d);

 // frag = (diffuse+0.4)*d*0.35 + pow(d, 128.0f)+0.03;

  float specPow = 320.0;

  // frag = 1.0*diffuse*(d*0.0+0.20) + 0.50*pow(d, specPow);
  frag = diffuse*0.50;



//  c.r = pow(c.r, 0.85);
//  c.g = pow(c.g, 0.55);
//  c.b = pow(c.b, 0.45);

//  c.r = pow(c.r, 1.20);
//  c.g = pow(c.g, 0.80);
//  c.b = pow(c.b, 1.10);

  frag.rgb *= pow(dot(myNormal, vec3(0.0, 1.0, 0.0))*0.5+0.5, 6.0);


  frag.a = diffuse.a*g_alpha;


  emitParticles(myNormal);


  vec4 c = frag;


 // c.rgb *= 0.20+vec3(clamp(myNormal.x, 0.0, 1.0))*0.80;

  frag3.rgb = clamp(c.rgb-g_emitThr, 0.0, 1000.0)*g_emitAmp; // emitBuf


  if (g_prevBlurType < 0.5) {
//      vec2 norkor = posG.xy/posG.z;
//      norkor.xy *= 0.8;
//      norkor.xy = norkor.xy*0.5+0.5;
      vec2 norkor = vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight);

     // vec3 prev = texture2D(texPrevFrame, (norkor.xy)+0.2*normal.xy).rgb;
     // prev = pow(prev, vec3(2.0));
     // c.rgb += g_prevAmount*pow(clamp(prev, 0.0, 2.0),vec3(1.0));
      vec2 paske = (norkor.xy)-0.1*myNormal.xy;
      paske = clamp(paske, 0.0, 1.0);
      vec3 prevb = texture2D(texPrevBlurFrame, paske).rgb;
      //prevb = pow(prevb, vec3(2.20));

      c.rgb += g_prevBlurAmount*pow(clamp(prevb-vec3(0.01), 0.0, 8.0),vec3(2.0));

  } else {

      vec3 normalB = (projectionMatrix*viewMatrix*vec4(myNormal, 0.0)).xyz;
      normalB /= normalB.z;
      vec2 norkor = vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight);
      vec2 paske = (norkor.xy)-0.025*(normalB.xy);
      paske = clamp(paske, 0.0, 1.0);
      float kk = 1.0;

   //   if (paske.x < 0.01 || paske.y < 0.01 || paske.x > 0.99 || paske.y > 0.99) kk = 0.0;

      vec3 jorge = texture2D(texPrevNorm, paske).rgb*1.0;
      vec4 efe = CalcEyeFromWindow(vec3(paske.x*g_windowWidth, paske.y*g_windowHeight, jorge.r));
      vec3 seze = (viewInvMatrix*vec4(efe.xyz, 1.0)).xyz*1.0;

      vec3 jorgeC = texture2D(texPrevNorm, norkor).rgb*1.0;
      vec4 efeC = CalcEyeFromWindow(vec3(norkor.x*g_windowWidth, norkor.y*g_windowHeight, jorgeC.r));
      vec3 sezeC = (viewInvMatrix*vec4(efeC.xyz, 1.0)).xyz*1.0;

      vec3 sp = seze-sezeC;
      float kx = (dot(sp, sp));
      float dok = 1.0/(clamp(kx, 0.0, 10000.0)*0.0+1.0);
      // if (kx > 100.0) dok = 0.0;
      dok = clamp(dok, 0.0, 100.0);

      sp/=sqrt(kx);
      float dok2 = dot(sp, -normal)+0.0;
      dok2 = clamp(dok2, 0.0, 1.0);

      float dok2a = 0.30;
      dok *= (dok2*dok2a+1.0-dok2a);

   //   dok = 1.0;

      vec3 prevb = texture2D(texPrevBlurFrame, paske).rgb*clamp(dok*kk, 0.0, 1.0);
      c.rgb += (0.0+1.0*g_prevBlurAmount*(pow(clamp(prevb-vec3(0.0), 0.0, 8.0),vec3(2.0))-vec3(0.0)));


      //c.rgb = seze*0.01;
      //c.rgb = vec3(dok);
  }

  c.rgb = clamp(c.rgb, 0.0, 10.0);


  frag = c;

  //frag.rgb = clamp(frag.rgb, 0.0, 1.0);


 // inster = posInst.x;
 // frag.rgb = vec3(inster*0.01);// vec3(float(int(fract((inster)*0.1)*5.0))*0.2);
 // frag.a = 1.0;

  frag = pow(frag, vec4(0.5));

  if (c.a < 0.001) discard;


   // frag.rgb = vec3(inster)*0.5;

//  frag.a = 1.0;

  frag2.rgb = -normalize(normalWSG).xyz;
  frag2 = clamp(frag2, -1.0, 1.0);
  frag2.a = 1.0;

  frag3 = pow(frag3, vec4(0.5));
  frag3.a = frag.a;

}

