import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: feed
    name: "feed"
    enabled: syncRoot(feed.name+".ON");

    property vector2d center: Qt.vector2d(sync(feed.name+".cen.x"), sync(feed.name+".cen.y"))
    property vector2d sca: Qt.vector2d(sync(feed.name+".sca.x"), sync(feed.name+".sca.y"))

    Shader { file: "feed" }
    Blit { textureRT: "current" }
    Texture { textureUnit: 0; textureRT: "current" }
    Texture { textureUnit: 1; textureRT: "feedPrev" }
    DrawVB {
        type: "quad"
        depthTest: false; depthWrite: false
        blendMode: "off"
        drawBuffers: 1
        ShaderParam { paramName: "g_prevAmount"; paramValueVec4: sync(feed.name+".prevAmount.r")+","+sync(feed.name+".prevAmount.g")+","+sync(feed.name+".prevAmount.b")+","+sync(feed.name+".prevAmount") }
        ShaderParam { paramName: "g_prevPow"; paramValueVec4: sync(feed.name+".prevPow.r")+","+sync(feed.name+".prevPow.g")+","+sync(feed.name+".prevPow.b")+","+sync(feed.name+".prevPow") }
        ShaderParam { paramName: "flip"; paramValue: sync(feed.name+".flip") }
        ShaderParam { paramName: "centerScale"; paramValueVec4: feed.center.x+","+feed.center.y+","+feed.sca.x+","+feed.sca.y }
    }
    Blit { textureRT: "feedPrev" }
    Shader { file: "feedMix" }
    DrawVB {
        type: "quad"
        depthTest: false; depthWrite: false
        blendMode: "off"
        drawBuffers: 1
        ShaderParam { paramName: "g_currentAmount"; paramValue: sync(feed.name+".currentAmount") }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 1.0 }
        ShaderParam { paramName: "flip"; paramValue: sync(feed.name+".flip") }
        ShaderParam { paramName: "centerScale"; paramValueVec4: feed.center.x+","+feed.center.y+","+feed.sca.x+","+feed.sca.y }
    }
}
