import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
  // space vortex plane
  id: spaceVortex
  enabled: syncRoot(spaceVortex.name+".ON");
  VariClock { id: vortexZoomTime; clockSpeed: sync(spaceVortex.name+".emitZoomSpeed"), 0.01}
  // do not modify this maxParticles dynamically on fly during the demo
  property int maxParticles: 1000000
  property int maxSimParticles: sync(emitPart.name+".sim.maxKParticles", 500.0)*1000.0

  property string blendMode: blendSel(name+".draw", 2.0)

  property int partEmitShaderIndex: sync(spaceVortex.name+".emit.shaderIndex")
  property string partEmitShader: {
      if (partEmitShaderIndex === 0) return "partEmit";
      if (partEmitShaderIndex === 1) return "partEmit1";
      return "partEmit";
  }

  property int partSimShaderIndex: sync(spaceVortex.name+".sim.shaderIndex")
  property string simShader: {
      if (partSimShaderIndex === 0) return "partSim_old";
      if (partSimShaderIndex === 1) return "partSim";
      if (partSimShaderIndex === 2) return "partSimSPH";
      return "partSim";
  }
//  property string simShader: "partSim"
  property string drawShader: "partDraw"
  property string emitMesh: meshSel(name+".emitMesh", 18)
  property alias meshParams: spaceMeshParams.delegate  

  Texture { textureUnit: 5; imageUnit: 5; textureRT: "voxelVel"}
  property real voxBD: 8.0
  property real voxAS: 1.0

  property real emitPosX: syncOsc(spaceVortex.name+".emitMesh.x")
  property real emitPosY: syncOsc(spaceVortex.name+".emitMesh.y")
  property real emitPosZ: syncOsc(spaceVortex.name+".emitMesh.z")

  property real emitMeshScale: syncOscFFT(spaceVortex.name+".emitMesh.scale", 1.0)

  property bool depthTest: false

  property bool autoSize: true

  property bool clearParticleEmits: true

  property real animFramesPerRow: sync(spaceVortex.name+".emitAnim.framesPerRow", 1.0)
  property int animFrames: Math.max(1.0, sync(spaceVortex.name+".emitAnim.frames", 1.0))
  property int animFrameInt: (animFrame.time.toFixed(0)/animFrames-Math.floor(animFrame.time.toFixed(0)/animFrames))*(animFrames-1)
  property real animFrameUVX: (animFrameInt/animFramesPerRow-Math.floor(animFrameInt/animFramesPerRow))*animFramesPerRow*sync(spaceVortex.name+".emitAnim.width", 1.0/6.0)
  property real animFrameUVY: Math.floor(animFrameInt/animFramesPerRow)*sync(spaceVortex.name+".emitAnim.height", 1.0/6.0)

  VariClockTrigger {
      id: vortexRotTime
      clockSpeed: sync(spaceVortex.name+".emitRotSpeed", 0.0)
      reset: vortexSim.partSimReset
  }
  RenderTarget {
      RenderTargetLayer {
          textureRT: spaceVortex.name+"emitVortexPartPos"
          format: "RGBA16F"
          width: windowWidth*1
          height: windowHeight*1
      }
  }
  RenderTarget {
      RenderTargetLayer {
          textureRT: spaceVortex.name+"emitVortexPartVel"
          format: "RGBA16F"
          width: windowWidth*1
          height: windowHeight*1
      }
  }
  RenderTarget {
      RenderTargetLayer {
          textureRT: spaceVortex.name+"emitVortexPartCol"
          format: "RGBA16F"
          width: windowWidth*1
          height: windowHeight*1
      }
  }

  ShaderAtomicCounter { name: spaceVortex.name+"sacVortex1"; clear: clearParticleEmits }
  Texture { textureUnit: 0; imageUnit: 0; textureRT: spaceVortex.name+"emitVortexPartPos" }
  Texture { textureUnit: 1; imageUnit: 1; textureRT: spaceVortex.name+"emitVortexPartVel" }
  Texture { textureUnit: 2; imageUnit: 2; textureRT: spaceVortex.name+"emitVortexPartCol" }

  Shader { file: partEmitShader }

  TextureSel { textureUnit: 0; name: spaceVortex.name+".emitMesh"; }
  Camera {
      x: emitPosX; y: emitPosY; z: sync(spaceVortex.name+".emitCamDist", 1.0)*emitMeshScale+emitPosZ
      lookAtX: emitPosX; lookAtY: emitPosY; lookAtZ: emitPosZ
      upX: 0.0; upY: 1.0; upZ: 0.0
  }

  property real uvScale: sync(spaceVortex.name+".emitUVScale", 1.0)


  VariClockTrigger {
      id: animFrame
      clockSpeed: sync(spaceVortex.name+".emitAnim.FPS", 0.0)
      reset: syncTrigger(spaceVortex.name+".emitAnim.reset")
  }

  DrawMesh {
    file: spaceVortex.emitMesh; enabled: true;
    //smoothNormals: true; normalSmoothAngle: 20;
    blendMode: "normal";
    depthTest: spaceVortex.depthTest;
    depthWrite: false;
    cull: false; cullBack: false;

//    autoScale: autoSize
//    autoCenter: autoSize
	
    ShaderParam { paramName: "g_uvScale"; paramValueVec4: (uvScale*sync(spaceVortex.name+".emitUVScaleX", 1.0))+","+(uvScale*sync(spaceVortex.name+".emitUVScaleY", 1.0))}
    ShaderParam { paramName: "g_texBrightness"; paramValue: sync(spaceVortex.name+".emitBright", 1.0)*0.01}
    ShaderParam { paramName: "g_uvOfsX"; paramValue: sync(spaceVortex.name+".emitUVOfsX", 0.0)+animFrameUVX }
    ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(spaceVortex.name+".emitUVOfsY", 0.0)+animFrameUVY }
    ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0}
    ShaderParam { paramName: "g_bump"; paramValue: 1.50}
    ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
    ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.10, 1.0"}
    ShaderParam { paramName: "g_bright"; paramValue: 1.0}
    ShaderParam { paramName: "g_zoomTime"; paramValue: vortexZoomTime.time }
    ShaderParam { paramName: "g_vortexRot"; paramValue: vortexRotTime.time }
    ShaderParam { paramName: "g_vortexRotOfs"; paramValue: sync(spaceVortex.name+".emitRotOfs", 0.0) }
    ShaderParam { paramName: "g_texGen"; paramValue: sync(spaceVortex.name+".emitTexGen", 0.0) }
    ShaderParam { paramName: "g_vortexScale"; paramValue: sync(spaceVortex.name+".vortexScale", 1.0) }
    ShaderParam { paramName: "g_emitType"; paramValue: sync(spaceVortex.name+".emitType", 1.0) } // 0: points, 1: surface
    ShaderParam { paramName: "g_emitPointSize"; paramValue: sync(spaceVortex.name+".emitPointSize", 0.0) }
    ShaderParam { paramName: "g_vortexAngSpeed"; paramValue: sync(spaceVortex.name+".emitAngSpd", 0.01) }
    ShaderParam { paramName: "g_emitPercent"; paramValue: sync(spaceVortex.name+".emitPercent", 10.0) }
    ShaderParam { paramName: "g_emitVelX"; paramValue: sync(spaceVortex.name+".emitVel.x") }
    ShaderParam { paramName: "g_emitVelY"; paramValue: sync(spaceVortex.name+".emitVel.y") }
    ShaderParam { paramName: "g_emitVelZ"; paramValue: sync(spaceVortex.name+".emitVel.z") }
    ShaderParam { paramName: "g_emitColorThr"; paramValue: sync(spaceVortex.name+".emitColThr") }
    ShaderParam { paramName: "g_emitGrayness"; paramValue: sync(spaceVortex.name+".emitGrayness") }
    ShaderParam { paramName: "g_alpha"; paramValue: sync(spaceVortex.name+".emitMeshDebug", 0.0) }

    ShaderParam { paramName: "g_emitLayers"; paramValue: sync(spaceVortex.name+".emitLayers", 1.0) }
    ShaderParam { paramName: "g_emitLayersDepth"; paramValue: sync(spaceVortex.name+".emitLayersDepth", 0.0) }

    Pos { x: spaceVortex.emitPosX; y: spaceVortex.emitPosY; z: spaceVortex.emitPosZ }
    Rot { d: syncOscFFT(spaceVortex.name+".emitMesh.rotX"); ax: 1.0; ay: 0.0; az: 0.0; }
    Rot { d: syncOscFFT(spaceVortex.name+".emitMesh.rotY"); ax: 0.0; ay: 1.0; az: 0.0; }
    Rot { d: syncOscFFT(spaceVortex.name+".emitMesh.rotZ"); ax: 0.0; ay: 0.0; az: 1.0; }
    Sca { s: emitMeshScale; z: sync(spaceVortex.name+".emitMeshScaZ", 1.0) }

    Repeater { id: spaceMeshParams; model: 1 }
    drawBuffers: 1
  }

  Camera { // back to flyCam
      property vector3d pos: flyCam.getCamPosSmooth()
      property vector3d lookAt: flyCam.getCamLookAtSmooth()
      property vector3d up: flyCam.getCamUpSmooth()

      x: pos.x; y: pos.y; z: pos.z
      lookAtX: lookAt.x; lookAtY: lookAt.y; lookAtZ: lookAt.z
      upX: up.x; upY: up.y; upZ: up.z
  }



//  Blit { textureRT: "depth"; blitRT: 1}

  // vortex partikles
  ShaderAtomicCounter { name: spaceVortex.name+"sacVortex1" }
  Texture { textureUnit: 0; imageUnit: 0; textureRT: spaceVortex.name+"emitVortexPartPos" }
  Texture { textureUnit: 1; imageUnit: 1; textureRT: spaceVortex.name+"emitVortexPartVel" }
  Texture { textureUnit: 2; imageUnit: 2; textureRT: spaceVortex.name+"emitVortexPartCol" }
  PartSim {
      id: vortexSim
      name: parent.name
      forceName: parent.name
      simShader: spaceVortex.simShader

      simShaderParams: ParamGroup {
          ShaderParam { paramName: "g_partDiscardBright"; paramValue: sync(vortexSim.name+".sim.discardBright") }
          ShaderParam { paramName: "g_maxSimParticles"; paramValue: spaceVortex.maxSimParticles }
          ShaderParam { paramName: "g_noiseOctFreq"; paramValue: sync(vortexSim.name+".sim.noiseOctFreq", 4.0) }
          ShaderParam { paramName: "g_stirHitVelScale"; paramValue: sync(vortexSim.name+".sim.hitVelScale", 0.0) }

//          property int numRadForces: sync(vortexSim.name+".sim.radForceNum")

          ShaderParam { paramName: "g_radForceStatic"; paramValue: sync(vortexSim.name+".sim.radForceStatic") }
          ShaderParam { paramName: "g_radForceDist"; paramValue: syncFFT(vortexSim.name+".sim.radForceDist") }
          ShaderParam { paramName: "g_radForceDamp"; paramValue: sync(vortexSim.name+".sim.radForceDamp") }
          ShaderParam { paramName: "g_radForcePos"; paramValueVec4: sync(vortexSim.name+".sim.radForceX")+","+sync(vortexSim.name+".sim.radForceY")+","+syncOsc(vortexSim.name+".sim.radForceZ") }

          ShaderParam { paramName: "g_radForce2Static"; paramValue: sync(vortexSim.name+".sim.radForce2Static") }
          ShaderParam { paramName: "g_radForce2Dist"; paramValue: syncFFT(vortexSim.name+".sim.radForce2Dist") }
          ShaderParam { paramName: "g_radForce2Damp"; paramValue: sync(vortexSim.name+".sim.radForce2Damp") }
          ShaderParam { paramName: "g_radForce2Pos"; paramValueVec4: sync(vortexSim.name+".sim.radForce2X")+","+sync(vortexSim.name+".sim.radForce2Y")+","+syncOsc(vortexSim.name+".sim.radForce2Z") }

          ShaderParam { paramName: "g_forceDelay"; paramValue: sync(spaceVortex.name+".forceDelay") }
          ShaderParam { paramName: "g_forceAttack"; paramValue: sync(spaceVortex.name+".forceAttack") }
          ShaderParam { paramName: "g_forceAttackExp"; paramValue: sync(spaceVortex.name+".forceAttackExp", 1.0) }

          ShaderParam { paramName: "g_voxelDim"; paramValue: voxBD }
          ShaderParam { paramName: "g_voxelAreaSize"; paramValue: voxAS }
      }

      drawShader: spaceVortex.drawShader
      drawShaderParams: ParamGroup {
          ShaderParam { paramName: "g_partBright"; paramValue: syncFFT(vortexSim.name+".draw.partBright", 1.0) }
          ShaderParam { paramName: "g_partAlpha"; paramValue: sync(vortexSim.name+".draw.partAlpha", 0.5) }
          ShaderParam { paramName: "g_ageAlphaFade"; paramValue: sync(vortexSim.name+".drawAgeFade", 0.0) }
          ShaderParam { paramName: "g_blendMode"; paramValue: spaceVortex.blendMode==="sub" ? 4.0 : 0.0 }
          ShaderParam { paramName: "g_agePaletteOfs"; paramValue: sync(vortexSim.name+".drawAgePalette.ofs", 0.0) }
          ShaderParam { paramName: "g_agePaletteFreq"; paramValue: sync(vortexSim.name+".drawAgePalette.freq", 1.0) }
          ShaderParam { paramName: "g_agePaletteFreqRand"; paramValue: sync(vortexSim.name+".drawAgePalette.freqrand", 0.1) }
          ShaderParam { paramName: "g_agePaletteYOfs"; paramValue: sync(vortexSim.name+".drawAgePalette.yofs", 0.0) }
          ShaderParam { paramName: "g_agePaletteYRand"; paramValue: sync(vortexSim.name+".drawAgePalette.yrand", 0.1) }
          ShaderParam { paramName: "g_agePaletteXRand"; paramValue: sync(vortexSim.name+".drawAgePalette.xrand", 0.1) }

          ShaderParam { paramName: "g_partSizeVar"; paramValue: sync(vortexSim.name+".draw.partSizeVar") }
          ShaderParam { paramName: "g_partSizeVarFreq"; paramValue: sync(vortexSim.name+".draw.partSizeVarFreq") }
          ShaderParam { paramName: "g_partMotionScale"; paramValue: sync(vortexSim.name+".draw.partMotBlur", 1.0) }
          ShaderParam { paramName: "g_partMotionScaleMax"; paramValue: sync(vortexSim.name+".draw.partMotBlurMax", 2.0) }

          ShaderParam { paramName: "g_partSharp"; paramValue: sync(vortexSim.name+".draw.partSharp", 1.0) }
          ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(vortexSim.name+".draw.prevBlur", 0.0) }


          ShaderParam { paramName: "g_dofFokus"; paramValueVec4: sync(vortexSim.name+".draw.dofFokus")+","+sync(vortexSim.name+".draw.dofFokusRange")+","+sync(vortexSim.name+".draw.dofGainNear")+","+sync(vortexSim.name+".draw.dofGainFar") }
          ShaderParam { paramName: "g_dofPart"; paramValueVec4: sync(vortexSim.name+".draw.dofGain")+","+sync(vortexSim.name+".draw.dofSharpness")+",0.0,0.0"  }
      }

      drawEnabled: spaceVortex.enabled
      drawBlendMode: spaceVortex.blendMode

      // textureDraw
      // tex0: TextureSel { textureUnit: 0; name: spaceVortex.name }

      // textureAgeSwipe
      tex2: TextureSel { textureUnit: 2; name: spaceVortex.name+".drawAgePalette"; }

      shaderVaryings: "
              vec3 posG;
              vec2 uvG;
              vec3 velG;
              vec3 colG;
              float ageG;
              float recG;
              float ageSplitG;
              vec4 paramsG;
              vec4 targetPosG;"


      // max particles count is gridDimension*gridDimension
      // CHANGE PROPOSAL: make a new parameter maxPoints instead...
      gridDimension: Math.sqrt(maxParticles)

      // This is actually the number of points drawn for the first frame
      // of the simulation (or when reset).
      // As after that, the simulation will continue with own number of particles
      // as some particles might die and others might emit new ones...
      // CHANGE PROPOSAL: because of the above explanation, change this variable name to
      // initNumPoints instead ...
      drawNumPoints: spaceVortex.maxSimParticles*0.1 // sync(spaceVortex.name+".numParticles")

      partSize: sync(spaceVortex.name+".draw.partSize", 1.0)
  }

  // leave this atomic counter active so some other effects shaders do not modify this by accident.....
  ShaderAtomicCounter { name: "none"; clear: true }


}
