import QtQuick 2.0
import QtGraphicalEffects 1.0
import "./_SharedQML"
import AdaptDemoSystem 1.0

Scene {
    id: debugInfo
    // property bool bDebugTexts: true
    property bool bDebugTexts: false

    property string name: "DebugInfo"
    property string sceneName: ""
    property string sceneDir: "fx/"+sceneName+"/"
    property bool bSceneEnabled: false

    anchors.fill: parent

    Connections {
        target: root
        onHideLoder: {
            loaderImageOver.visible = false;
        }
    }

    Item {
        id: loaderImageOver
        anchors.fill: parent
        layer.enabled: true

        onVisibleChanged: {
            if (!visible) {
                console.log("Demo loader image hidden");
            }
        }

        Image {
            anchors.fill: parent
            source: "../images/adapt.png"
            //source: "../images/loader.png"
        }
    }

    DrawRT {
        visible: loaderImageOver.visible
        enabled: loaderImageOver.visible
        textureItem: loaderImageOver
        flip: true
    }



    onSetSceneName: {
        sceneName = sn;
        name = sn;
    }
    sceneEnabled: bSceneEnabled
    enabled: bSceneEnabled

}

