//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDb3ab6dd9_cb8f_4a61_babb_03050ec0542b
{
    public class Class_grain : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Time = 2,
            BlendMode = 3,
            ShowNoise = 4,
            SRGB = 5,
            Speed = 6,
            Intensity = 7,
            Mean = 8,
            Variance = 9
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var Time = inputs[(int)InputId.Time].Eval(context).Value;
            var BlendMode = (int) inputs[(int)InputId.BlendMode].Eval(context).Value;
            var ShowNoise = inputs[(int)InputId.ShowNoise].Eval(context).Value;
            var SRGB = inputs[(int)InputId.SRGB].Eval(context).Value;
            var Speed = inputs[(int)InputId.Speed].Eval(context).Value;
            var Intensity = inputs[(int)InputId.Intensity].Eval(context).Value;
            var Mean = inputs[(int)InputId.Mean].Eval(context).Value;
            var Variance = inputs[(int)InputId.Variance].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Time").AsScalar().Set(Time);
                    _effect.GetVariableByName("BlendMode").AsScalar().Set(BlendMode);
                    _effect.GetVariableByName("ShowNoise").AsScalar().Set(ShowNoise);
                    _effect.GetVariableByName("SRGB").AsScalar().Set(SRGB);
                    _effect.GetVariableByName("Speed").AsScalar().Set(Speed);
                    _effect.GetVariableByName("Intensity").AsScalar().Set(Intensity);
                    _effect.GetVariableByName("Mean").AsScalar().Set(Mean);
                    _effect.GetVariableByName("Variance").AsScalar().Set(Variance);
                //<<< _setup
                
                _effect.GetVariableByName("UpdateCount").AsScalar().Set(_updateCount++);

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }
        
        int _updateCount;

    }
}

